Ext.define('Academia.view.personinfo.student.LockPersonalDetailsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.lockpersonaldetailsgrid',	
	store : 'student.managehold.LockPersonalDetailsGridStore', 
	title:getCommonTranslation('LOCK_PERSONAL_DETAILS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar:[{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSavePrivilege'
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
	}],	
	columns:[{
		header:getCommonTranslation('FIELD_DISPLAY_NAME'),
		dataIndex:'displayName',
		flex:0.1,
		sortable:true,
		renderer:function(displayName) {
			return displayName;
		}
	},{
	    xtype: 'checkcolumn',
	    header: getCommonTranslation('LOCK_UNLOCK_FIELD'),
	    flex: 0.1,
	    sortable: true,
	    dataIndex: 'isLocked',
	    listeners: {
	        checkchange: function (checkColumn, rowIndex, checked) {
	            var grid = checkColumn.up('grid');
	            var store = grid.getStore();
	            var record = store.getAt(rowIndex);

	            if (record && typeof record.set === 'function') {
	                record.set('isLocked', checked);
	            }
	        }
	    }
	}],
	plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1
	}
});