/**
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.personinfo.student.LockPersonalDetailsTab', {
    extend: 'Ext.form.Panel',
    alias: 'widget.lockpersonaldetailstab',
    cls: 'panelNoSpace',
	autoScroll: false,
	frame:false,
	cls:'horizontal-scrolling-fix',
	
	style:{overflow:'hidden !important',margin:'0!important'}, 
	items : [{
		xtype:'panel',
		items:[{
			xtype:'hidden',
			name:'action'
		},{
			xtype : 'lockpersonaldetailsgrid',
			itemId:'lockPersonalDetailsGridItemId'
		}]
	}],
	listeners: {
        activate: function (panel) {
            var grid = panel.down('#lockPersonalDetailsGridItemId');
            if (grid) {
                var store = grid.getStore();
                // Reload the store to reset the data
                store.load({
                    callback: function (records, operation, success) {
                        if (success) {
                            Ext.each(records, function (record) {
                                if (!isNullOrEmpty(record.get("displayName"))) {
                                    record.set("displayName", record.get("displayName"));
                                }
                                if (!isNullOrEmpty(record.get("isLocked"))) {
                                    record.set("isLocked", record.get("isLocked"));
                                }
                            });
                        }
                    }
                });
            }
        }
    }        
});
