/**
 * @author <a href="harshit.patidar@serosoft.in">Harshit patidar</a>
 *
 */
Ext.define('Academia.view.personinfo.student.ProofOfActivityForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.proofofactivityform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'proof_of_activity_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('RESEARCH_ACTIVITY'),
			store: Ext.create('Academia.store.common.ResearchActivityCSMStore'),
			itemId: 'researchActivity',
			name: 'researchActivity',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: false,
			forceSelection:true,
			//cls:'commonAutoHeightMultiselectField',
			listConfig: {
				loadingText: getCommonTranslation("SEARCHING"),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('RESEARCH_ACTIVITY_NAME'),
            itemId : "researchActivityName",
            name: 'researchActivityName',
            allowBlank: false,
            maxLength:100,
            maskRe: /[A-Za-z0-9\s]/,
            disabled:true
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('RESEARCH_ACTIVITY_DATE'),
			itemId : "researchActivityDate",
            name: 'researchActivityDate',
          // --submitFormat: CONSTANTS.DATE_FORMAT,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank:false,
            vtype : 'daterange'
		}]
    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 260
	        },
	    items: [{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            editable : false,
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
            		obj = dateFormatRender(obj);
            		obj.setValue(new Date());
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'proofofactivitydocumentgrid',
			itemId:'proofofactivitydocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadProofOfActivityItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
