/**
 *  Student Termination Quick Search form
 */
Ext.define('Academia.view.personinfo.student.StudentCommonQuickSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentcommonquicksearch',
    cls:'customSearchPanel',
    frame : false,
    items: [/*{
        xtype: 'form',
        itemId: 'studentQuickSearchForm',
        collapsible: true,
        frame: true,
        height: '30%',
        title: getPersonModuleTranslation('QUICK_SEARCH'),
        defaults: {
            labelAlign: 'top'
        },
        standardSubmit: false,
        items: [*/{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),
                name: 'ADMISSION_NUMBER'
            }, {
                /*xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('STUDENT_ID'),
                name: 'STUDENT_ID'*/
            	xtype: 'customcombobox',
    			name: 'STUDENT_ID',
    			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
    			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
    			valueField: 'studentCode',
    			displayField: 'valueCode',
    			queryParam:'studentNameOrCode',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			forceSelection:true,
    			typeAhead:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode}/{studentName}' +
    					'</div>';
    				}
    			}

            }, {
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
                store : 'common.SelectNameComboStore',
                editable : false,
                queryMode : 'local',
                name: 'selectedNameField',
                itemId: 'selectedNameField',
                valueField: 'id',
                displayField: 'value',
                value: 'FIRST_NAME'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
                itemId: 'selectedName',
                name: 'FIRST_NAME'
            }, {
            	xtype: 'customcombobox',
                name: 'PROGRAM_NAME',
                itemId: 'program',
                fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
               // editable: false,
                valueField: 'id',
                displayField: 'valueCode',
    			minChars:3,
    			allowBlank: true,
    			typeAhead:false,
    			queryParam:'programName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                        combo.bindStore(store);
                    }
               },
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}'+ 
	                    '</div>';
	                }
	            }
                
            }, {
                xtype: 'customcombobox',
                name: 'BATCH_NAME',
                itemId: 'batch',
                fieldLabel: getPersonModuleTranslation('BATCH'),
                disabled:true,
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                itemId:'period',
                disabled:true,
                editable: false,
                displayField: 'value',
                valueField: 'id',
                queryMode: 'local',
                fieldLabel: getPersonModuleTranslation('PERIOD'),
                name: 'PERIOD_NAME',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }
            },{
                xtype: 'customcombobox',
                name: 'COURSE_NAME',
                itemId: 'course',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
                queryMode: 'name',
//                editable: false,
                disabled:true,
                valueField: 'id',
                displayField: 'valueCode',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.coursetransaction.coursereading.CourseByPeriod');
                        combo.bindStore(store);
                    }
                },
                queryParam:'name',
    			minChars:3,
    			typeAhead:false,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{value}' +
    	                    '</div>';
    	                }
    	            }
            }, {
                xtype: 'customcombobox',
                name: 'SECTION',
                itemId: 'section',
                fieldLabel: getPersonModuleTranslation('SECTION'),
                editable: false,
                queryMode: 'local',
                disabled:true,
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.CourseSectionCombo');
                        combo.bindStore(store);
                    }
                }
            } ]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'studentDebarmentSearchButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getServiceRequestTranslation('CLEAR_SEARCH'),
                itemId: 'studentListClearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});