/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.personinfo.student.StudentForAcademicToicsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentforacademictoicsgrid',
	store: 'personinfo.student.StudentForAcademicToicsStore',
	title: getPersonModuleTranslation('ACADEMICS_TOPIC'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: { 
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'studentforacademictoicsstructure': 3
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId :'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.student.StudentForAcademicToicsStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header: getPersonModuleTranslation('ADMISSION_CODE'),
		dataIndex: 'admission',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getPersonModuleTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if (!isNullOrEmpty(record.data.student)) {
				return record.data.student.code;  
			}else{
				return '';
			}
		}
	},{
		header: getPersonModuleTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	}, {
		header: getPersonModuleTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getPersonModuleTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getPersonModuleTranslation('PERIOD'),
		dataIndex: 'period',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value)
				return value.value
				else 
					return '';  
		}
	},{
		header: getCommonTranslation('ACADEMIC_TERM'),
		dataIndex: 'academicTerm',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value)
				return value.value
				else 
					return '';  
		}
	},{
		header: getCommonTranslation('DATE'),
		dataIndex: 'date',
		flex:.3,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('ACADEMICS_TOPIC'),
		dataIndex: 'academicTopics',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	},{
		header: getCommonTranslation('ACADEMICS_SUB_TOPIC'),
		dataIndex: 'academicSubTopics',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			return value.value;  
		}
	}, {
		header: getPersonModuleTranslation('DESCRIPTION'),
		dataIndex: 'description',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				return "";
			} else {
				rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				return val;
			}
		}
	},{
		header: getCommonTranslation('CREATED_DATE'),
		dataIndex: 'createdAt',
		flex:.3,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('CREATED_BY'),
		dataIndex: 'createdBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('UPDATED_DATE'),
		dataIndex: 'updatedAt',
		flex:.3,
		sortable: true,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('UPDATED_BY'),
		dataIndex: 'updatedBy',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			return val.code.toLowerCase() + '/' + val.value;
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'Status',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('UPLOADED_DOCUMENT'),
		dataIndex: 'academicTopicDocuments',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('documentName'))) {
				var value1=!isNullOrEmpty(rec.record.get('documentName'))?rec.record.get('documentName'):rec.record.data.name;
				var newPath=rec.record.data.path;    
				var val=!isNullOrEmpty(value1)?value1:newPath;
				return "<a href='javascript:void(0)'>"+val;
			}
			else {
				return "";
			}
		}
	},{
		header: getCommonTranslation('UPLOADED_URL'),
		dataIndex: 'academicTopicUrls',
		flex:.3,
		sortable: true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(rec.record.get('urlName'))) {
				if(rec.record.get('academicTopicUrls').length == 1) {
					value = rec.record.get('academicTopicUrls')[0].name;
					var value1=!isNullOrEmpty(value)?value:rec.record.get('academicTopicUrls')[0].name;
					var newPath=rec.record.get('academicTopicUrls')[0].path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href="+newPath+" target='_blank'>"+val;
				}
				else {
					var value1=!isNullOrEmpty(rec.record.get('urlName'))?rec.record.get('urlName'):rec.record.data.name;
					var newPath=rec.record.data.path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href='javascript:void(0)'>"+val;
				}
			}
			else {
				return "";
			}
		}
	}]
});
