/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentHoldReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentholdreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	//style: 'margin: 0 16px !important',
	plugins:"formlabelrequired",
	/*items:[{
		xtype:'form',
		cls:'customSearchPanel',*/
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'academyLocationId',
				itemId: 'academyLocationItemId',
				fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
				width: 740,
				maxHeight:75,
				store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
				allowBlank : false,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	            	 xtype: 'customcombobox',
		    			name:'programHoldReport',
		    			store:Ext.create('Academia.store.common.ProgramByAcademyLocationStore'),
		    			itemId:'programHoldReport',
		    			fieldLabel: getCommonTranslation('PROGRAM'),
		    		   // disabled:true,
		    			valueField: 'id',
		    			displayField: 'value',
		    			queryParam:'programName',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		    			  listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{code} / {value}'+ 
		    	                    '</div>';
		    	                }
		    	            }
		    		
				},{
					xtype: 'customcombobox',
					name: 'intakeHoldReport',
					itemId: 'intakeHoldReport',
					fieldLabel: getPersonModuleTranslation('BATCH'),
					store:Ext.create('Academia.store.enquiry.AcademicBatchStore'),
					disabled:true,
					valueField: 'id',
					displayField: 'value',
					queryParam:'qry',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					itemId:'periodHoldReport',
					name: 'periodHoldReport',
					store: Ext.create('Academia.store.program.programDetails.programBatches.ProgramPeriodNameStore'),
					forceSelection:true,
					hideTrigger:false,	 
					queryParam:'qry',
					triggerAction: 'all',
					disabled:true,
					displayField: 'value',
					valueField: 'id',
					queryMode: 'local',
					fieldLabel: getPersonModuleTranslation('PERIOD'),
					
				}]
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	    			xtype: 'customcombobox',
	    			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
	    			name: 'seatTypeHoldReport',
	    			itemId: 'seatTypeHoldReport',
	    			store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
    				valueField: 'seatTypeId',
    				displayField: 'seatTypeName',
    				queryMode : 'local',
    				hideTrigger:false,	 
    				queryParam:'qry',
    				triggerAction: 'all',
    				disabled:true,
    			
	    		},{
					xtype: 'customcombobox',
					name: 'STUDENT_ID',
					itemId:'studentIdReportHold',
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
	            }]
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	                xtype: 'customcombobox',
	                name: 'holdCatNameReportHold',
	                itemId: 'holdCatNameReportHold',
	                fieldLabel: getCommonTranslation('HOLD_CATEGORY_NAME'),
	                store:Ext.create('Academia.store.student.managehold.StudentHoldCategoryNameStore'),
	                valueField: 'id',
	                displayField: 'value',
	    			typeAhead:true,
	    			forceSelection:true
	            },{
	                xtype: 'customcombobox',
	                name: 'holdSubCatNameReportHold',
	                itemId: 'holdSubCatNameReportHold',
	                fieldLabel: getCommonTranslation('HOLD_SUB_CATEGORY_NAME'),
	            	valueField: 'id',
	    			displayField: 'valueCode',
	    			store:Ext.create('Academia.store.student.managehold.StudentSubHoldCategoryNameStore'),
	                typeAhead:true,
					forceSelection:true
	            },{
					xtype: 'customcombobox',
					name: 'applyHoldAtHoldReport',
					itemId:'applyHoldAtHoldReport',
					fieldLabel: getCommonTranslation('APPLY_HOLD_AT'),
					valueField: 'id',
					displayField: 'value',
					store:Ext.create('Academia.store.feeandpayment.finance.FinanceHoldTypeStore'),
					typeAhead:true,
					forceSelection:true
				}]
			}]
		},
		{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	                xtype: 'customcombobox',
	                name: 'appliedBy',
	                itemId: 'appliedBy',
	                fieldLabel: getCommonTranslation('APPLIED_BY'),
	                store:Ext.create('Academia.store.coursetransaction.sectionmanagement.FacultyIdValueSmartSearch'),
	               displayField: 'valueCode',
	   			   valueField:'id',
	               queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
	            },{
	                xtype: 'customcombobox',
	                name: 'removedBy',
	                itemId: 'removedBy',
	                fieldLabel: getCommonTranslation('REMOVED_BY'),
	               store:Ext.create('Academia.store.coursetransaction.sectionmanagement.FacultyIdValueSmartSearch'),
	                valueField: 'id',
	                displayField: 'valueCode',
	                queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
	            },{
					xtype: 'checkbox',
					name: 'showRemoveHold',
					itemId:'showRemoveHold',
					style: 'margin-top: 25px; margin-left: 9px',
					labelAlign: 'left',
					boxLabel: getCommonTranslation('DO_NOT_SHOW_REMOVE_HOLD'),
				}]
			}]
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtnHoldReportItemID',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				//formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnHoldReportSUItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//}]
});