Ext.define('Academia.view.personinfo.student.StudentListOfApplicableConditionsAdmGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.studentlistofapplicableconditionsadmgrid',
    title: getAdmissionTranslation('LIST_OF_APPLICABLE_CONDITIONS'),
    border: true,
    autoScroll: true,
    columnLines: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        handler: function() {
            var grid = this.up('grid');
            var store = grid.getStore();
            var cellEditing = grid.getPlugin('celleditingPluginId');

            // Check if there's any unsaved new row; if yes, do not add another
            var newRowExist = store.findBy(function(record) {
                return record.phantom; // This identifies the unsaved newly added record
            });

                var newRow = store.add({
                    sNO: store.getCount() + 1, // Auto-increment row number
                    admissionConditionValue: '', // Empty value for the new condition
                    conditionCheck: false,
                    offerType: '',
                    conditionSatisfactionDate: null,
                    saqaTrackingNumber: '',
                    isSaved: false // Initialize as not saved
                })[0];

                cellEditing.startEdit(newRow, grid.columns[1]);  // Start editing the new row at the "CONDITIONS" column (index 1)
            }
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
    }],
    columns: [{
        xtype: 'rownumberer',
        header: getCommonTranslation('SNO'),
        dataIndex: 'sNO',
        sortable: true,
        align: 'center',
        flex: 1
    }, {
        header: getCommonTranslation('CONDITIONS'),
        dataIndex: 'admissionConditionValue',
        sortable: true,
        flex: 2.2,
        editor: {
            xtype: 'customcombobox',
            store: Ext.create('Academia.store.admission.applicationFormSale.AdmissionConditionByOfferTypeStore'),
            queryMode: 'remote',
            valueField: 'itemValue',
            displayField: 'itemValue',
            itemId: 'admissionCondition',
            listConfig: {
            	width: null,
                minWidth: 150,
                listeners: {
                    select: function(combo, record, index) {
                    	setTimeout(function(){
                    	var this$ = this;
                        var grid = Ext.ComponentQuery.query('studentlistofapplicableconditionsadmgrid')[0];
                        var selectedRow = grid.getSelectionModel().getSelection()[0];
                        var selectedConditionId = record.get('id');
                        var isDuplicate = false;
                        var programGrid = Ext.ComponentQuery.query('studentprogramwiseconditionsadmissionadmgrid');
                        var selectedRecord =programGrid[0].getSelectionModel().getSelection()[0];
                        if(selectedRecord){
							grid.getStore().each(function(record) {
						        if (record.get('admissionConditionId') === selectedConditionId && record !== selectedRow) {
						            isDuplicate = true;
						            return false;
						        }
						    });
						
						    if (isDuplicate) {
						        var comboboxes = Ext.ComponentQuery.query('customcombobox[itemId=admissionCondition]');
						        if (comboboxes.length > 0) {
						            var combobox = comboboxes[0];
						            if (combobox.isXType('customcombobox')) {
						            	combobox.setValue("");
						            	selectedRow.set('admissionConditionId', null);
	                                    selectedRow.set('admissionConditionValue', "");
	                                    selectedRow.set('offerType', ''); 
						            }
						        }
						        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('APPLICABLE_CONDITION_ALREADY_SELECTED_MSG'));
						    } else {
						        selectedRow.set('admissionConditionId', selectedConditionId);
						        selectedRow.set('admissionConditionValue', record.get('itemValue'));
						
						        if (record.data.projectNumber === 'Provisional') {
						            selectedRow.set('offerType', 'Yes');
						        } else {
						            selectedRow.set('offerType', 'No');
						        }
						    }
                        }
                    },200);
                    },
                    blur: function(combo) {
                    	if (combo.getValue() === null || combo.getValue() === "") {
                            var grid = Ext.ComponentQuery.query('studentlistofapplicableconditionsadmgrid')[0];
                            var selectedRow = grid.getSelectionModel().getSelection()[0];
                            combo.setValue("");
                            selectedRow.set('admissionConditionValue', "");
                            selectedRow.set('offerType', "");
                        }
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND')
            }
        },
        renderer: function(itemValue, metadata, record) {
            if (record.data.offerType === 'PROVISIONAL' || record.data.offerType === 'Yes') {
                return itemValue + '<span class="required" style="color:red"> *</span>';
            } else {
                return itemValue;
            }
        }
    }, {
        xtype: 'checkcolumn',
        header: getCommonTranslation('CONDITIONS_MET'),
        flex: 1.9,
        sortable: false,
        dataIndex: 'conditionCheck',
        listeners: {
            beforecheckchange: function(checkcolumn, rowIndex, checked, eOpts) {
                if (portalId === 3) {
                    return false;
                }
            }
        }
    }, {
    	header:getCommonTranslation('SAQA_TRACKING_NUMBER'),
		flex:1.5,
		sortable:true,
		dataIndex : 'saqaTrackingNumber',
		editor : {
			xtype : 'textfield',
			 itemId:'saqaTrackingNumber',
	         name:'saqaTrackingNumber',
			
		}
	}, {
        header: getCommonTranslation('MANDATORY'),
        dataIndex: 'offerType',
        sortable: true,
        flex: 1.1,
        renderer: function(value, metadata, record) {
            if (value === "PROVISIONAL" || value === "Yes") {
                return 'Yes';
            } else if (value === "FIRM" || value === "No") {
                return 'No';
            } else {
                return '';
            }
        }
    }, {
        header: getCommonTranslation('DATE_OF_SATISFACTION'),
        dataIndex: 'conditionSatisfactionDate',
        name: 'conditionSatisfactionDate',
        itemId: 'conditionSatisfactionDate',
        sortable: true,
        flex: 1.5,
        editor: {
            xtype: 'datefield',
            itemId: 'conditionSatisfactionDate',
            name: 'conditionSatisfactionDate',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            var store = grid.getStore();
            var models = grid.getStore().getRange();
            if (!isNullOrEmpty(val)) {
            } else if (!isNullOrEmpty(record.data.datePrefillValue)) {
                val = record.data.datePrefillValue;
            }
            models[rowIndex].set("conditionSatisfactionDate", val);
            models[rowIndex].set("datePrefillValue", val);
            return dateRender(val);
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1,
        pluginId: 'celleditingPluginId',
        listeners: {
            // Disable editing for all rows except the newly added one
            beforeedit: function(editor, context) {
                var record = context.record;
                var column = context.column;

                // Allow editing for DATE_OF_SATISFACTION and CHECK columns regardless of the record state
                if (column.dataIndex === 'conditionSatisfactionDate' || column.dataIndex === 'conditionCheck' || column.dataIndex === 'saqaTrackingNumber') {
                    return true;
                }

                // Allow editing for the CONDITIONS column only if the record is new (not saved)
                if (column.dataIndex === 'admissionConditionValue') {
                    return record.phantom; // Only editable if the record is new
                }

                return false; // Default to not allowing edit
            }
        }
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.admission.applicationFormSale.StudentProgramWiseContitionDetailStore');
    }
});
