/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentListStudentProgramTransferForm', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentliststudentprogramtransferform',
	method: 'POST',
	autoScroll:false,
	margin: '30 10 0 10',
	bodyPadding: '10 10 0 10',
	layout: 'anchor',
	standardSubmit: false,
	border: true,
	plugins:"formlabelrequired",
	title: getCommonTranslation('SELECT_NEW_PROGRAM'),
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
			name: 'academyLocationCombo',
			itemId:'academyLocationCombo',
			store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
			displayField: 'value',
			valueField: 'id',
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			queryMode: 'remote',
			queryParam: 'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'intakeYear',
			itemId: 'intakeYearItemId',
			allowBlank: false,
			fieldLabel: getCommonTranslation('INTAKE_YEAR'),
			store: Ext.create('Academia.store.common.IntakeYearStoreByBatchId'),
			valueField: 'id',
			displayField: 'value',
			forceSelection: true,
			editable: false,
			cls:'commonAutoHeightMultiselectField',
			disabled: true
		},{
			xtype: 'customcombobox',
			name: ' programGroup',
			itemId:'Program_Group',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store: Ext.create('Academia.store.program.ProgramGroupByAccessibleALStore'),
			editable: false,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			allowBlank: false,
			disabled: true
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('PROGRAM'), //Program
			name: 'PROGRAM',
			itemId: 'program',
			autoload: false,
			store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'qry',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank: false,
			disabled: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('BATCH'),   //Batch
			name: 'BATCH',
			itemId: 'batch',
			editable: false,
			autoload: false,
			store: Ext.create('Academia.store.common.BatchesByProgramId'),
			valueField: 'id',
			displayField: 'value',
			queryMode : 'local',
			allowBlank: false,
			disabled: true
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('PERIOD'), //Period
			name: 'PERIOD',
			itemId: 'periodId',
			editable: false,
			autoload: false,
			store:Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.programTransferToPeriodStore'),
			valueField: 'id',
			displayField: 'value',
			queryMode : 'local',
			allowBlank: false,
			disabled: true
		}]
	},{

		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
			name: 'SEAT_TYPE',
			itemId: 'seatType',
			editable: false,
			autoload: false,
			store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local',
			allowBlank: false,
			disabled: true
		},
		{
			xtype: 'customcombobox',
			fieldLabel: getProgramandcourseTranslation('SECTION'), //Section
			name: 'SECTION',
			itemId: 'section',
			editable: false,
			autoload: false,
			store:Ext.create('Academia.store.program.programbatchdetail.SectionByPeriodId'),
			valueField: 'id',
			displayField: 'code',
			queryMode : 'local',
			allowBlank: true,
			disabled: true
		},
		{
			xtype: 'customcombobox',
			fieldLabel: getHostelTranslation('REFUND_RULE_APPLICABLE'), //Section
			name: 'refundRuleApplicable',
			itemId: 'refundRuleApplicable',
			editable: false,
			autoload: false,
			store:Ext.create('Ext.data.Store', {
			    fields: ['id', 'value'],
			    data : [
			        {"id":"REFUND_0_PERCENTAGE", "value":getCommonTranslation('REFUND_0_PERCENTAGE')},
			        {"id":"REFUND_50_PERCENTAGE", "value":getCommonTranslation('REFUND_50_PERCENTAGE')},
			        {"id":"REFUND_100_PERCENTAGE", "value":getCommonTranslation('REFUND_100_PERCENTAGE')}
			    ]
			}),
			valueField: 'id',
			displayField: 'value',
			queryMode : 'local',
			allowBlank: true,
			hidden: true
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype:'checkbox',
			name: 'retainStudentData',
			boxLabel: getAdmissionTranslation('RETAIN_STUDENT_DATA'),
			itemId:'retainStudentDataId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true,
			cls: 'checkBoxEllipsisCls'
		},{
			xtype:'customcombobox',
			name: 'courseEnrollmentStatus',
			fieldLabel: getCommonTranslation('COURSE_ENROLLMENT_STATUS'),
			itemId:'courseEnrollmentStatusId',
			editable: false,
			autoload: false,
			store: Ext.create('Ext.data.Store', {
                fields: ['id', 'value'],
                data: [{
                    id: 'ENROLLED',
                    value: getCommonTranslation('ENROLLED')
                }, {
                    id: 'UNENROLLED',
                    value: getCommonTranslation('UN_ENROLLED')
                }]
            }),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			disabled: true
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype:'checkbox',
			name: 'retainAcademicData',
			boxLabel: getAdmissionTranslation('RETAIN_ACADEMIC_DATA'),
			itemId:'retainAcademicDataId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true,
			cls: 'checkBoxEllipsisCls'
		},{
			xtype:'checkbox',
			name: 'retainFeeAndPaymentData',
			boxLabel: getAdmissionTranslation('RETAIN_FEE_AND_PAYMENT_DATA'),
			itemId:'retainFeeAndPaymentDataId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true,
			cls: 'checkBoxEllipsisCls'
		},{
			xtype:'checkbox',
			name: 'retainServiceOpted',
			boxLabel: getAdmissionTranslation('RETAIN_SERVICE_OPTED'),
			itemId:'retainServiceOptedId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true//,
			//cls: 'checkBoxEllipsisCls'
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 536
		},
		items: [{
			xtype:'checkbox',
			name: 'isCalculateSeparateCGPAndSGPA',
			boxLabel: getExaminationTranslation('CALCULATE_SEPARATE_CGPA_AND_SGPA_FOR_THE_PROGRAM'),
			itemId:'isCalculateSeparateCGPAndSGPAId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true
		},{
			xtype:'checkbox',
			name: 'retainExamData',
			boxLabel: getExaminationTranslation('RETAIN_EXAMINATION_DATA'),
			itemId:'retainExamDataId',
			inputValue: true,
			uncheckedValue: false,
			disabled:true,
			cls: 'checkBoxEllipsisCls'
		}]
	}, {
		xtype: 'fieldcontainer',
		width: 'auto',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
            xtype: "checkbox",
            name: "isCurrentAcademicTerm",
            itemId: "isCurrentAcademicTermId",
            inputValue: true,
            uncheckedValue: false,
            hidden: true,
            cls: "checkBoxEllipsisCls"
		}]
	}, {
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'saveBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'cancelBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			handler :function(button) {
				button.up('window').destroy();
			}
		}]	
	}]
});