/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.personinfo.student.StudentManageHoldFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentmanageholdfilter',
    cls:'customSearchPanel',
    frame : false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'holdCategoryName',
                itemId: 'holdCategoryName',
                fieldLabel: getCommonTranslation('HOLD_CATEGORY_NAME'),
                store:'student.managehold.StudentAllHoldCategoryNameStore',
                valueField: 'id',
                displayField: 'value',
    			minChars:3,
    			queryParam:'codeOrName',
    			enableKeyEvents  : 'true',
    			typeAhead:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: 'all',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            }, {
                xtype: 'customcombobox',
                name: 'holdCategoryStatus',
                itemId: 'holdCategoryStatus',
                fieldLabel: getCommonTranslation('HOLD_CATEGORY_STATUS'),
                editable: false,
                queryMode: 'local',
                store:Ext.create('Academia.store.common.StatusComboStore'),
                displayField: 'name',
                valueField: 'value',
                value:'Active',
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'studentHoldSearchButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            },{
                xtype: 'button',
                text: getServiceRequestTranslation('RESET'),
                itemId: 'studentHoldClearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});