/**
 * @author Amit G
 */
Ext.define('Academia.view.personinfo.student.StudentPrintTaxCertificate', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentprinttaxcertificate',
	modal: true,
	frame: true,
	title:getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE'),
	items: [{		
    xtype: 'form',
    defaults:{
    	labelAlign:'top',
    	width: 256
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
    	xtype: 'customcombobox',
    	fieldLabel: getFeeAndPaymentCommonTranslation('FINANCIAL_YEAR'),
    	itemId: 'mappedAccountingYear',
    	name: 'mappedAccountingYear',
    	store:Ext.create('Academia.store.feeandpayment.controlAccount.MappedAccountingYearType'),
    	valueField:'id',
    	displayField:'value',
    	allowBlank:false,
    	editable: false,
    },{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			itemId: 'btnPrint',
			text : getCommonTranslation('SUBMIT'),
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{

			xtype: 'button',
			itemId: 'cancelButton',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		
		}]	
	}]
	}]
});
