/**
 * @author Amit G
 * This is used to show CONDITIONS_FOR_ADMISSIONS Application and Admission
 */
Ext.define('Academia.view.personinfo.student.StudentProgramWiseConditionsForAdmission', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.studentprogramwiseconditionsforadmission',
    cls: 'x-form-fixed-footer-parent',
    items: [{
    	xtype: 'panel',
    	width:'100%',
    	height:'auto',
    	items: [{
    		xtype : 'studentprogramwiseconditionsadmissionadmgrid',
    		itemId: 'studentProgramWiseConditionsAdmissionAdmGridItemId',
    		isFixHeightGrid: true,
    		tbar: [],
    		minHeight: 0,
    		style: {
    			'margin-left': '0px !important;'
    		}
    	},{
    		xtype: 'panel',
        	layout: 'hbox',
        	style: {
    			'margin-right': '18px !important;'
    		},
        	items: [{
        		xtype: 'studentpwconditionsadminadmdocumentgrid',
        		itemId: 'studentPWConditionsAdminAdmDocumentGridItemId',
        		cls:'no-empty-placeholder-grid margin-for-hbox-grid',
        		width:460,
        		isFixHeightGrid: true,
        		isFixWidthColums: true,
        		minHeight: 92
        	},{
        		xtype: 'studentlistofapplicableconditionsadmgrid',
        		itemId: 'studentListofApplicableConditionsAdmgridItemId',
        		cls:'no-empty-placeholder-grid margin-for-hbox-grid',
        		flex: 1,
        		isFixHeightGrid: true,
        		isFixWidthColums: true,
            	minHeight: 100
        	}]	
    	}]

    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	itemId:'formFieldContainerItemId',
    	defaults: {
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'textarea',
    		name: 'txtAdmAdditionalCondition',
    		width: 536,
    		itemId: 'txtAdmAdditionalConditionItemId',
    		fieldLabel: getAdmissionTranslation('ADDITIONAL_CONDITIONS'),
    		readOnly:true,
    		maxLength:1000	
    	},{
    		xtype: 'datefield',
    		fieldLabel: getAdmissionTranslation('DATE_FOR_SATISFACTION_OF_CONDITION'),
    		name: 'admDateOfSatisfactionCondition',
    		itemId: 'admDateOfSatisfactionConditionItemId',
    		width: 256,
    		readOnly:true,
    		listeners: {
    			render: function(field) {
    				return dateFormatRender(field);
    			}
    		}
    	}]
	},{
    xtype: 'fieldcontainer',
    width: 'auto',
    items: [{
    	xtype: 'panel',
    	width:'100%',
    	items: [{
    		xtype : 'additionaladmissionapproverform',
    		itemId: 'additionaladmissionapproverform',
    	}]

    }]
	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		cls: 'form-fixed-footer',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			style:{'margin-left':'10px'},
			formBind: true,
			itemId: 'admPWCSubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});