Ext.define('Academia.view.personinfo.student.StudentUploadPhotoWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.studentuploadphotowindow',
    title: getCommonTranslation('PROFILE_PHOTO'),
    modal: true,
    width: 550,
    height: 540,
    resizable: false,
    closable: true,
    border: false,
    cropData: null,
	component:null,
	autoScroll:false,
	imagesUrl: '',
	captureImageaUrl:'',
	bodyCls: 'uploadPhotoWinCls',
	style:{
		'overflow-y': 'hidden !important'
	},
	items:[{
		xtype:'form',
		height: 500,
		autoScroll:false,
		width: '100%',
		itemId:'profileImageFormItemId',
		layout: {
			type: 'vbox',
			align: 'center',
			//pack: 'center',
		},
		items: [{
			// Profile Image Container
			xtype: 'container',
			width: 320,
			height: 280,
			layout: {
				type: 'vbox',
				align: 'center',
				style: {
					position: 'relative',
				}
			},
			itemId: 'profile_image_containerBox',
			items: [{
				xtype: 'image',
				itemId: 'profile_image',
				border: 1,
				style: {
					borderColor: '#e0e0e0',
					borderStyle: 'solid',
					borderRadius: '50%',
					marginTop:'67px !important'
				},
				width: 210,
				height: 210,
				src: 'resources/images/default-profile.png',
//				margin: '0 0 3 0', // Adds spacing around the image
			},{
				xtype: 'hidden',
				name: 'isImageRemoved',
				itemId: 'isImageRemovedItemId'
			}]
		},
		{
			id:'capture_panel',
			itemId:'capturePanelId',
			hidden:true,
			listeners:{
				show:function(obj){
					Webcam.set({
						width: 320,
						height: 240,
						crop_width: 320,
						crop_height: 240,
						flip_horiz: true,
						image_format: 'jpeg', // image format (may be jpeg or png)
						jpeg_quality: 100 // jpeg image quality from 0 (worst) to 100 (best)
					});
					Webcam.attach('#capture_panel-innerCt');
				},
				hide: function () {
					Webcam.reset();
				}
			}
		},{
			xtype:'panel',
			itemId:'previewPanelId',
			hidden:true
		},{
			xtype:'panel',
			hidden:true,
			html: "<canvas  id='canvas' width='310' height='272'></canvas>"
		},
		// Button Container for Profile Actions
		{
			xtype: 'container',
			width:'100%',
			layout: {
				type: 'hbox',
				align: 'middle',
				pack: 'center',
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('EDIT'),
				name: 'btnEdit',
				itemId: 'btnEditItemId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				cls: 'editPhotoAfterBackCls'
			},{
				xtype: 'button',
				text: getCommonTranslation('REMOVE'),
				name: 'btnRemove',
				itemId: 'btnRemoveItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				disabled: true,
				cls: 'btn-with-no-icon removePhotoBtn'
			},{
				xtype: 'filefield',
				buttonText: getCommonTranslation('UPLOAD_PHOTO'),
				name: 'file',
				itemId: 'btnUploadPhotoItemId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true,
				buttonOnly: true
			}, {
				xtype: 'hidden',
				name: 'name',
				itemId: 'fileName'
			}, {
				xtype: 'hidden',
				name: 'personId',
				itemId: 'personId'
			}, {
				xtype: 'button',
				text: getCommonTranslation('TAKE_A_PHOTO'),
				name: 'btnTakePhoto',
				itemId: 'btnTakePhotoItemId',
				cls:'btnTakePhotoStudentCls',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CAPTURE'),
				name: 'capturePhoto',
				itemId: 'capturePhotoItemId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true,
				margin: '0 10 0 0'
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				name: 'resetPhoto',
				itemId: 'resetPhotoItemId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true,
				cls: 'btn-with-no-icon btnResetPhotoStudentCls'
			}]
		},
		{
			xtype: 'button',
			cls: 'profileRoatateImageIcon',	
			itemId: 'profileRoatateImageIconId',
			hidden: true,
			rotate: 0.1
		},{
			xtype:'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				name: 'btnCancel',
				itemId: 'btnCancelItemId',
				 ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,	
			},{
				xtype: 'button',
				text: getCommonTranslation('BACK'),
				name: 'btnBack',
				itemId: 'btnBackItemId',
				 ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true,
			},{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				name: 'btnSave',
				itemId: 'btnSaveItemId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				disabled: true
			}]
			
		}]
	}]
});
