/**
 * this window is used to show the Company type popup .
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.createcompany.AddTypeWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.addtypewindow',
	title:getPlacementTranslation('Add Company'),
	autoScroll:true,
	modal:true,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items:[{
 
	        xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            labelAlign: 'top',
	            width: 256
	        },
			items:[{
				xtype: 'textfield',
				name: 'companyCode',
				itemId:'companyCode',				
				fieldLabel: getPlacementTranslation('Company Code'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
			},{
				xtype: 'textfield',
				name: 'companyName',
				itemId:'companyName',
				fieldLabel: getPlacementTranslation('Company Name'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textfield',
				name: 'locationCode',
				itemId:'locationCode',
				fieldLabel: getPlacementTranslation('Location Code'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
			},{
				xtype: 'textfield',
				name: 'locationName',
				itemId:'locationName',
				fieldLabel: getPlacementTranslation('Location Name'),
				allowBlank:false,
				enforceMaxLength : true,
				maxLength:255,
			}]
		
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'startDate',
				itemId:'startDate',
				vtype : 'daterange',
				fieldLabel: getPlacementTranslation('Start Date'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
			
			},{
				xtype: 'datefield',
				name: 'tillDate',
				itemId:'tillDate',
				vtype : 'daterange',
				fieldLabel: getPlacementTranslation('Till Date'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
			
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
		       	 xtype: 'customcombobox',
		            fieldLabel: getPlacementTranslation('COMPANY_STATUS'),
		            value:true,
		            store: 'common.StatusComboStore',
		            itemId: 'status',
		            name:'status',
		            valueField: 'value',
		            displayField: 'name'
		       },/*{
					xtype: 'textfield',
					text: getPlacementTranslation('Manage Address'),
					formBind: true,
					itemId: 'manageAddress',
					ui: 'CustomBtnSubmit',
				}*/]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[	{
					xtype: 'photouploadform',
					itemId: 'path'
				},]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getPlacementTranslation('SAVE'),
				formBind: true,
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getPlacementTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		
		
		}]
	}]
		
});