/**
 * @author Amit.G
 */

Ext.define('Academia.view.placement.placementcampus.PlacementCampusApplyToProgramPeriodEditForm',{
	extend: 'Ext.window.Window',
	alias: 'widget.placementcampusapplytoprogramperiodeditform',
	title:getPlacementTranslation('ADD_PROGRAM_PERIOD'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'programperiodform',
		itemId:'placementcampusapplytoprogramperiodform',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'nestedJsonCombo',
				name: 'academyLocation',
				itemId:'academyLocation',
				store:'placement.placementcampus.PlacementCampusProgramPeriodOALStore',
				allowBlank:false,
				fieldLabel: getPlacementTranslation('ACADEMY_LOCATION'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'academyLocationName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				width: 256,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			
			},{
				xtype: 'nestedJsonCombo',
				name: 'programName',
				itemId:'programId',
				fieldLabel: getCommonTranslation('PROGRAM'),
				store:'common.PlacementProgramByAcademyLocationStore',
				allowBlank:false,
				valueField: 'id',
				displayField: 'value',
				enforceMaxLength : true,
				maxLength:255,
				queryParam:'programName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				width: 256,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},
				regex: /[a-zA-Z0-9]+/
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'nestedJsonCombo',
				name: 'batchName',
				itemId:'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store:'common.PlacementBatchesByProgramStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				disabled:true,
				forceSelection:true
			},{
				xtype: 'nestedJsonCombo',
				name: 'periodName',
				itemId:'periodId',
				fieldLabel: getPlacementTranslation('PLACEMENT_PERIOD'),
				 store:'program.programDetails.programBatches.courseParameter.PlacementProgramCoursePeriodStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				disabled:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});