/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusForm',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias : 'widget.placementcampusform',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	title: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_DETAIL'),
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	cls:'x-form-fixed-footer-parent',
	items : [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			name : 'campusCode',
			itemId:'campusCode',
			fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_CODE'),
			allowBlank:false
		},{
			xtype : 'textfield',
			name : 'campusName',
			itemId:'campusName',
			fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_NAME'),
			allowBlank:false
		},{
            xtype: 'customcombobox',
            name: 'intakeYearPlcDriveId',
            itemId: 'intakeYearPlcDriveId',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            store: Ext.create('Academia.store.common.IntakeYearStore'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false, 
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'nestedJsonCombo',
			name: 'placementType',
			itemId:'placementType',
			store:'placement.PlacementTypeStore',
			allowBlank:false,
			fieldLabel: getPlacementTranslation('PLACEMENT_TYPE'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		},{
			xtype: 'nestedJsonCombo',
			name:'campusCoordinator',
			itemId:'campusCoordinator',
			store: 'placement.placementcampus.placementCampusCoordinatorStore',
			fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'nestedJsonCombo',
			name: 'placementMOD',
			itemId:'placementMOD',
			store:'placement.PlacementDriveMODStore',
			fieldLabel: getPlacementTranslation('PLACEMENT_MOD'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		}]
	},{

		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'datefield',
			name: 'startDate',
			itemId:'startDate',
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			endDateField: 'endDate',
			editable:false,
			allowBlank:false,
			fieldLabel:getPlacementTranslation('START_DATE')
		},{
			xtype: 'datefield',
			name: 'endDate',
			itemId:'endDate',
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			startDateField: 'startDate',
			editable:false,
			fieldLabel:getPlacementTranslation('END_DATE')
		},{
			xtype: 'nestedJsonCombo',
			name: 'organizingAcademyLocation',
			itemId:'organizingAcademyLocation',
//			store:'placement.placementcampus.placementCampusOrgAlStore',
			store:'user.UserAcademyLocationStore',
			allowBlank:false,
			fieldLabel: getPlacementTranslation('ORGANIZING_ACADEMY_LOCATION'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		}]    
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'droolsRule',
			itemId:'droolsRule',
			store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
			fieldLabel : getPlacementTranslation('APPLICABLE_RULE'),
			allowBlank:true,
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		},{
			xtype: 'nestedJsonCombo',
			name: 'activityDurationType',
			itemId:'activityDurationTypeItemId',
			store:'placement.PlacementActivityDurationTypeStore',
			allowBlank:true,
			hidden:true,
			fieldLabel: getCommonTranslation('ACTIVITY_DURATION_TYPE'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		},{
			xtype: 'nestedJsonCombo',
			name: 'activityTypeIdentifier',
			itemId:'activityTypeIdentifierItemId',
			store:'placement.PlacementActivityTypeIdentifierStore',
			allowBlank:true,
			hidden:true,
			fieldLabel: getCommonTranslation('ACTIVITY_TYPE_IDENTIFIER'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'country',
			itemId:'countryItemId',
			store: Ext.create('Academia.store.common.CountryStore'),
			fieldLabel : getCommonTranslation('COUNTRY'),
			allowBlank:true,
			hidden:true,
			valueField : 'id',
    		displayField : 'countryName',
    		queryParam:'countryName',   		        						
			forceSelection :true,
			typeAhead : false,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{countryName}'  +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'nestedJsonCombo',
			name: 'hostIdentifier',
			itemId:'hostIdentifierItemId',
			store:'placement.PlacementHostIdentifierStore',
			allowBlank:true,
			hidden:true,
			fieldLabel: getCommonTranslation('HOST_IDENTIFIER'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		},{
			xtype: 'nestedJsonCombo',
			name: 'hostIdentifierType',
			itemId:'hostIdentifierTypeItemId',
			store:'placement.PlacementHostIdentifierTypeStore',
			allowBlank:true,
			fieldLabel: getCommonTranslation('HOST_IDENTIFIER_TYPE'),
			valueField: 'id',
			hidden:true,
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'mobilityScheme',
			itemId:'mobilitySchemeItemId',
			store: 'placement.PlacementMobilitySchemeStore',
			fieldLabel : getCommonTranslation('MOBILITY_SCHEME'),
			allowBlank:true,
			valueField: 'id',
			hidden:true,
			displayField: 'value',
			typeAhead:true,
			disabled:false,
			forceSelection:true  
		},{
			xtype : 'textfield',
			name : 'moduleInstanceIdentifier',
			itemId:'moduleInstanceIdentifierItemId',
			hidden:true,
			fieldLabel : getCommonTranslation('MODULE_INSTANCE_IDENTIFIER'),
			maxLength : 50,
			allowBlank:true
		}]
	},{

		xtype:'fieldcontainer',
		layout:'hbox',
		defaults: {
			width: 300,
			labelAlign: 'top'
		},
		items:[{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				labelAlign: 'top',
				itemId:'documentRequired',
				fieldLabel: getPlacementTranslation('DOCUMENT_REQUIRED'),
				disabled:false,
				columns: 2,
				vertical: true,
				items: [{ boxLabel: getPlacementTranslation('YES'), name: 'documentRequired', inputValue: true},
				        { boxLabel: getPlacementTranslation('NO'), name: 'documentRequired', inputValue: false,checked:true}
				]
			}]				
		},{
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				labelAlign: 'top',
				itemId:'JobStatusItem',
				fieldLabel: getPlacementTranslation('ALLOW_STUDENT_APPLICATION_IF_JOB_OFFERED'),
				disabled:false,
				//editable: false,
				columns: 2,
				vertical: true,
				items: [{ boxLabel: getPlacementTranslation('YES'), name: 'JobStatusItem', inputValue: true,checked:true},
				        { boxLabel: getPlacementTranslation('NO'), name: 'JobStatusItem', inputValue: false}
				]
			}]				
		}]
	},{

		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 536,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'documentCount',
			store:'placement.placementcampus.PlacementCampusDocumentStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			itemId:'documentCount',
			typeAhead:true,
			queryParam:'name',
			minChars:3,
			width: 536,
			hidden:true,
			fieldLabel:getPlacementTranslation('DOCUMENTS'),
			autoloadStore: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
		xtype: 'textarea',
		name:'remarks',
		itemId:'remarks',
		width: 536,
		maxLength : 250,
		fieldLabel: getPlacementTranslation('REMARKS')
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		cls:'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SAVE') ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
    		text: getCommonTranslation('RESET'),
    		//itemId: 'programFormCancelButtonId',
    		itemId: 'resetBtn',
    		ui: 'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});