/**
 * @author Amit G
 */
Ext.define('Academia.view.placement.placementcampus.PlacementCampusRecruitingOrganizationGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementcampusrecruitingorganizationgrid',
	store: 'placement.placementcampus.PlacementCampusRecruitingOrganizationGridStore',
	title: getPlacementTranslation('RECRUITING_ORGANIZATION'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'placement.placementcampus.PlacementCampusGridStore',
			store : 'placement.placementcampus.PlacementCampusRecruitingOrganizationGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveRecruitingAcademyLocationId',
			tooltip: getExaminationTranslation('SAVE'),
			//ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			style: {
				color: 'var(--text-icon-color-reverse) !important',
				font: 'var(--cta02-font-style) !important',
				background: 'var(--text-icon-color-accent) !important',
				textIconColorPrimary: 'var(--text-icon-color-reverse) !important',
				height: '36px !important',
				padding: '8px !important',
				borderRadius: '2px !important',
				letterSpacing: '0.42px !important',
				margin: '0px !important',
//				marginRight: '10px !important',
				marginLeft: '10px !important',
				textAlign: 'left !important'
			},
			listeners: {
				afterrender: function (btn) {
					setTimeout(function () {
						var inner = btn.getEl().down('.x-btn-inner'),
						btnExportToPDF = btn.up("toolbar").down('#btnExportToPDF');
						if (inner) {
							btnExportToPDF.getEl().setStyle({
								marginLeft: '-1px'
							});
							btn.getEl().setStyle({
								marginLeft: '2px'
							});
							inner.setStyle({
								color: 'var(--text-icon-color-reverse) !important',
								font: 'var(--cta02-font-style)'
							});
						}
					}, 100);
				}
			}
		}/*,{
			xtype:'textfield',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			width: 300,
			name:'academyLocation',
			itemId:'academyLocationItemId',
			cls: 'SearchTextFieldWithSmallHeader'
		}*/]
	},{
		xtype: 'button',
		itemId: 'btnReset',
		tooltip: getExaminationTranslation('RESET'),
		text:getExaminationTranslation('RESET'),
		hidden:true
	}],
	columns: [{
		header: getPlacementTranslation('RECRUITING_ORGANIZATION'),
		dataIndex: 'academyLocation',
		flex:.9,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
	},{
		header: getPlacementTranslation('ACADEMIC_YEAR'),
		dataIndex: 'academyYear',
		flex:.9,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}
		
	},{
		header: getPlacementTranslation('OWNER'),
		dataIndex: 'owner',
		flex:.9,
		renderer:function(value){
			if(!isNullOrEmpty(value))
				return value.value;
			else 
				return null;

		}		
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});