/**
 * @author Abhishek Chouhan
 * 
 */
Ext.define('Academia.view.placement.placementjob.PlacementAppliedJobFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.placementappliedjobfilter',
	autoScroll: false,
	cls:'customSearchPanel horizontalScrollingFixed',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 220,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    displayField:'valueCode',
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academyLocation',
			store:'placement.placementcampus.PlacementJobPostingROStore',
			allowBlank:true,
			fieldLabel: getPlacementTranslation('COMPANY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		},{
			xtype: 'customcombobox',
            name: 'status',
            itemId:'status',
            store:'common.StatusComboStore',
            displayField:'name',
            valueField:'name',
            forceSelection:true,
            editable:false,
            typeAhead:true,
            fieldLabel:getCommonTranslation('STATUS'),
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'appliedJobSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'appliedJobresetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
