/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.placementjob.PlacementAppliedJobGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementappliedjobgrid',
	store: 'placement.placementjobapplication.PlacementAppliedJobGridStore',
	title:  getPlacementTranslation('PLACEMENT_LIST_OF_APPLIED_JOBS'),
	border: true,
	frame:false,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementjobapplication.PlacementAppliedJobGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text: getPlacementTranslation('UPLOAD_RESUME'),
		itemId: 'uploadResume',
		buttonAlign: 'left',
	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
		dataIndex: 'jobTitle',
		flex:1,
		sortable:true
	},{
		header:  getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
		dataIndex: 'placementCampus',
		flex:1,
		sortable:true
	},{
		header:  getPlacementTranslation('COMPANY'),
		dataIndex: 'recruitingOrgName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('LOCATIONSTABTEXT'),
		dataIndex: 'noOfLocation',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.noOfLocation == 0){
					return '';
				} else {
					 return '<a href=#>'+value+'</a>'
				}
			}                        
		}
	},/*{
		header:  getCommonTranslation('DATE'),
		dataIndex: 'jobLocation',
		flex:.1,
		sortable:true
	},*/{
		header:  getPlacementTranslation('STATUS'),
		dataIndex: 'applicationStatus',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.applicationStatus=="APPLIED")
				{	
				return getCommonTranslation("APPLIED");
			} else {
				return getCommonTranslation("SELECTED");
			}
		  }
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SELECTION_STAGE'),
		dataIndex: 'selectionStageName',
		flex:1,
		sortable:true,
		
		
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_OFFER_STATUS'),
		dataIndex: 'offerStatus',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) { 
				 if(record.data.offerStatus=="PENDING")
				{	
				return getCommonTranslation("PENDING");
			} else {
				if(record.data.offerStatus=="OFFERED")
				{	
				return getCommonTranslation("OFFERED");
			}else if(record.data.offerStatus=="REJECTED")
				{	
				return getCommonTranslation("REJECTED");
			}else
				return getCommonTranslation("WAITING") ;
			} 
		  }
		}
	},{
		header:  getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'),
		dataIndex: 'joiningStatus',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.joiningStatus=="PENDING")
				{	
				return getCommonTranslation("PENDING");
			} else {
				return getCommonTranslation("JOINED");
			}
		  }
		}
	},{
		header:  getPlacementTranslation('RESUME'),
		dataIndex: 'documentName',
		flex:1,
		sortable:true,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}else{
				return null;
			}
		}
	},{
	    header: getPlacementTranslation('DOCUMENTS'),
	    dataIndex: 'offerLetterDocName',
	    flex: 1,
	    sortable: true,
	    renderer: function(value) {
	        if (!isNullOrEmpty(value)) {
	            return '<a href="#">' + value + '</a>';
	        } else {
	            return null;
	        }
	    }
	}]
});
