/**
 * @author Vishal Joshi
 * 
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationFilter', {
	extend: 'Ext.form.FormPanel',
	alias: 'widget.placementjobapplicationfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'placementjobapplication',
			itemId:'placementjobapplicationItemId',
			store:'placement.placementcampus.PlacementCampusStore',
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'jobtitle',
			itemId:'jobtitle',
			store:'placement.placementjobapplication.PlacementJobApplicationTitleStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			fieldLabel:getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE')
			
		},{
			xtype: 'customcombobox',
			name: 'academyLocation',
			itemId:'academyLocation',
			store:'placement.placementcampus.PlacementJobPostingROStore',
			fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width: 256,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
			
		}]
	},{
		
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [
		        {
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 256,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'customcombobox',
		        		name:'applicationStatus',
		        		itemId:'applicationStatus',
		        		store: 'placement.placementjobapplication.PlacementJobApplicationStatusStore',
		        		fieldLabel : getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STATUS'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'code',
		        		
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'selectionStage',
		        		itemId:'selectionStage',
		        		store:'placement.placementjobapplication.PlacementJobApplicationStageStatusStore',
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SELECTION_STAGE'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true 
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'offerStatus',
		        		itemId:'offerStatus',
		        		store:'placement.placementjobapplication.PlacementJobApplicationOfferStatusStore',
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('PLACEMENT_JOB_APPLICATION_OFFER_STATUS'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		typeAhead:true,
		        		disabled:false,
		        		forceSelection:true
		        	}]	
		        },{
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 256,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'nestedJsonCombo',
		        		name: 'joiningStatus',
		        		itemId:'joiningStatus',
		        		fieldLabel: getPlacementTranslation('PLACEMENT_JOB_APPLICATION_JOINING_STATUS'),
		        		store:'placement.placementjobapplication.PlacementJobApplicationJoiningStatusStore',
		        		allowBlank:true,
		        		valueField: 'id',
		        		displayField: 'value',
		        		disabled:false,
		        		enforceMaxLength : true,
		        		maxLength:255,
		        		regex: /[a-zA-Z0-9]+/
		        		
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'programName',
		        		itemId:'programId',
		        		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		        		store:'placement.placementjobapplication.PlacementJobApplicationProgramStore',
		        		valueField: 'id',
		        		displayField: 'valueCode',
		        		queryParam:'programName',
		    			minChars:3,
		    			typeAhead:true,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width: 256,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'batchId',
		        		itemId:'batchId',
		        		fieldLabel: getCommonTranslation('BATCH'),
		        		store:'placement.placementjobapplication.PlacementJobApplicationBatchByProgramStore',
		        		valueField: 'id',
		        		displayField: 'value',
		        		allowBlank: true,
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true
		        	}]
		        },{
		        	xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 256,
		        		labelAlign: 'top'
		        	},
		        	items : [{
		        		xtype: 'customcombobox',
		        		name:'studentName',
		        		itemId:'studentName',
		        		store: 'placement.placementjobapplication.PlacementJobApplicationStudentNameStore',
		        		fieldLabel : getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_NAME'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'studentName',
		        		minChars:3,
		        		typeAhead:false,
		        		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		        		enableKeyEvents  : 'true',
		        		hideTrigger:false,
		        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		        		triggerAction: '',
		        		forceSelection:true,
		        		allowBlank:true,
		        		disabled:true,
		        		listConfig: {
		        			listeners: {
		        				beforeshow: function(picker) {
		        					picker.minWidth = picker.up('combobox').getSize().width;
		        				}
		        			},
		        			loadingText: getCommonTranslation('SEARCHING'),
		        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        			getInnerTpl: function() {
		        				return '<div class="search-item">' +
		        				'{value}' +
		        				'</div>';
		        			}
		        		}
		        	}] 

		        }]
		
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
