/**
 * @author Amit.G
 */

Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationJobApplyWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.placementjobapplicationjobapplywindow',
	title:getPlacementTranslation('APPLY'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		formCode:'jobapplywindow',
		itemId:'placementjobapplicationjobapplywindow',
		plugins : "formlabelrequired",
		/*layout: {
			type: 'vbox'
		},*/
		defaults: {
			labelAlign: 'top',
			width:380
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 380,
				labelAlign: 'top'
			},
			items:[{
				
				xtype: 'customcombobox',
				name: 'recruitingOrganization',
				itemId:'recruitingOrganization',
				store:'placement.placementjobapplication.PlacementJobApplicationROStore',
				allowBlank:false,
				fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
				valueField: 'id',
				displayField: 'value',
				width:380,
				queryParam:'academyLocationName',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
				
				
			}]
			
			},{
				xtype: 'customcombobox',
				name: 'jobtitle',
				itemId:'jobtitle',
				store:'placement.placementjobapplication.PlacementJobApplicationTitleStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				allowBlank : false,
				fieldLabel:getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE')
		},{
			
			xtype: 'multiselectcombofield',
    		name: 'multiselectPlacementLocation',
    		itemId: 'multiselectPlacementLocation',
    		allowBlank : true,
    		store: 'placement.placementjobapplication.PlacementLocationStore',
    		fieldLabel : getPlacementTranslation('PLACEMENT_JOB_LOCATION_NAME'),
    		valueField: 'id',
    		displayField:'value',
    		maxLength:15000,
    		typeAhead: true,
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});