/**
 * @author Amit G
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobApplicationUpdateOfferWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.placementjobapplicationupdateofferwindow',
	title:getPlacementTranslation('PLACEMENT_JOB_APPLICATION_SEND_LETTER'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'placementjobapplicationupdateofferwindow',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{

				xtype:'displayfield',
				name:'recruitingOrganization',
				itemId:'recruitingOrganization',
				fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
			},{
				xtype:'displayfield',
				name:'jobtitle',
				itemId:'jobtitle',
				fieldLabel:getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE')
			},{
				xtype:'displayfield',
				name:'placementCampus',
				itemId:'placementCampus',
				fieldLabel : getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
	            name: 'status',
	            itemId:'statusItemId',
	            store:'placement.placementjobapplication.PlacementJobApplicationOfferStatusStore',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            allowBlank:false,
	            editable:false,
	            typeAhead:true,
	            fieldLabel:getCommonTranslation('STATUS'),
			},{
				xtype: 'customcombobox',
				name: 'jobLocation',
				itemId:'jobLocation',
				store:'placement.placementjobapplication.PlacementLocationStore',
				fieldLabel: getPlacementTranslation('JOB_LOCATIONS'),
				displayField:'value',
				emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
				valueField:'id',
				editable: true,	
				disabled:true,
				queryParam:'placementJobLocation',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				width: 256,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				},

			},{
				xtype: 'customcombobox',
				name: 'designation',
				itemId:'designation',
				store:'placement.placementjobapplication.PlacementJobApplicationDesignationStore',
				allowBlank:false,
				fieldLabel: getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				typeAhead:true,
				disabled:true,
				forceSelection:true
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{
				xtype: 'numberfield',
				itemId: 'saleryPKG',
				name: 'saleryPKG',
				fieldLabel: getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
				mouseWheelEnabled:false,
				hideTrigger:true,
				minValue:0,
				maxLength:8,
				allowDecimals:false,
				disabled:true,
				allowBlank:false,
			},{	
				xtype: 'datefield',
        		name: 'dateOfJoining',
        		itemId:'dateOfJoining',
        		disabled:true,
        		allowBlank:false,
        		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			}
        		},
        		//vtype: 'daterange',
				//endDateField: 'endDate',
				editable:false,
				minValue: new Date(),
        		fieldLabel:getPlacementTranslation('DATE_OF_JOINING')
			},{
				xtype : 'textfield',
				name : 'stipend',
				itemId:'stipend',
				fieldLabel : getCommonTranslation("STIPEND"),
				maxLength: 55
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items:[{
				xtype:'offerletterdownloddocgrid',
				style:{marginTop:'15px',marginLeft:'0px'},
//				width:300
			},{
				xtype: 'customcombobox',
	            name: 'sponsorId',
	            itemId:'sponsorId',
	            store:'sponsorship.Sponsors',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            editable:false,
	            typeAhead:true,
	            fieldLabel:getCommonTranslation('SPONSOR_NAME'),
	            style:{marginTop:'10px',marginLeft:'0px'}
			},{
				xtype: 'textareafield',
				fieldLabel: getPersonModuleTranslation('REMARK'),
				name: 'remarks',
				itemId : 'remarksJobItemId',
				maxLength:255,
				width: 536,
				style:{marginTop:'10px',marginLeft:'0px'}
			}]
		},{
			xtype:'fieldcontainer',
			width: 'auto',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				name: 'updateStatusDocument',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'updateStatusDocument',
				ui: 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE
				
			}]
		}]	
	}]
});