/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.placement.placementjobapplication.PlacementJobLocationGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.placementjoblocationgridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '50%',
	width: '70%',
	title:getPlacementTranslation('JOB_LOCATIONS'),
	items: [{
		xtype: 'form',
		method: 'POST',
//		margin: 0,
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype:'fieldcontainer',
			itemId:'fieldcontainerId',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'displayfield',
				name : 'jobTitle',
				itemId:'jobTitle',
				fieldLabel:  getPlacementTranslation('PLACEMENT_JOB_JOB_TITLE'),
			},{
				xtype:'displayfield',
				name : 'placementCampus',
				itemId : 'placementCampus',
				fieldLabel:  getPlacementTranslation('PATH_PLACEMENT_CAMPUS'),
			},{
				xtype:'displayfield',
				name : 'recruitingOrgName',
				itemId : 'recruitingOrgName',
				fieldLabel:  getPlacementTranslation('COMPANY'),
			}]
		}]
	},{
		xtype: 'grid',
		itemId : 'placementjobLocationGrid',
        store:'placement.placementjobapplication.PlacementJobLocationWindowStore',
		frame: false,
		border:true,
		autoScroll: true,
		title:getPlacementTranslation('JOB_LOCATIONS'),
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		features: [{
	        ftype: 'summary',
	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	    }],
		columns: [{
			header:  getPlacementTranslation('JOB_LOCATION'),
			dataIndex: 'placementJobLocationMaster',
			flex:.1,
			sortable:true,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}
		},{
			header:  getPlacementTranslation('PLACEMENT_JOB_DESIGNATION'),
			dataIndex: 'placementDesignation',
			flex:.1,
			sortable:true,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}
		},{
			header:  getPlacementTranslation('PLACEMENT_JOB_NO_OF_POSITIONS'),
			dataIndex: 'noOfPosition',
			flex:.1,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value;
				else 
					return null;

			}			
		},{
			header:  getPlacementTranslation('PLACEMENT_JOB_LOCATION_SALARY_PACKAGE'),
			dataIndex: 'placementSalaryRange',
			flex:.1,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}
		},{
			header:  getPlacementTranslation('PLACEMENT_JOB_COORDINATOR'),
			dataIndex: 'coordinator',
			flex:.1,
			renderer:function(value){
				if(!isNullOrEmpty(value))
					return value.value;
				else 
					return null;

			}
		},] 	
	}]
});
