/**
 * @author Amit.Gupta
 */
Ext.define('Academia.view.placement.placementtype.PlacementTypeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.placementtypegrid',
	store: 'placement.placementtype.PlacementTypeGridStore',
	title: getCommonTranslation('PLACEMENT_TYPE_LIST'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'placementtypetabstructure':1
		}
	},
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'placement.placementtype.PlacementTypeGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getPlacementTranslation('PLACEMENT_TYPE_NAME'),
		dataIndex: 'placementType',
		flex:.1,
		sortable:true
	},{
		header:  getPlacementTranslation('CONSIDER_FOR_PROGRAM_COMPLETION_IN_GRID'),
		dataIndex: 'whetherCompletion',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.whetherCompletion){
				return getPlacementTranslation('YES');
			}else{
				return getPlacementTranslation('NO');
			}
		}
	},{
		header:  getPlacementTranslation('WHETHER_GRADED'),
		dataIndex: 'whetherGraded',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.whetherGraded){
				return getPlacementTranslation('YES');
			}else{
				return getPlacementTranslation('NO');
			}
		}
	},{
		header:  getPlacementTranslation('WHETHER_MANDATORY'),
		dataIndex: 'whetherMandatory',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.whetherMandatory){
				return getPlacementTranslation('YES');
			}else{
				return getPlacementTranslation('NO');
			}
		}
	}]
});

