/**
 * @author Amit G
 */
Ext.define('Academia.view.program.OutcomeBasedEducationGrid.MapCourseAndProgramOutComesGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mapcourseandprogramoutcomesgrid',
    store: 'program.MapCourseAndProgramOutcomeStore',
    title: getProgramandcourseTranslation('LIST_OF_MAPPED_COURSE_PROGRAM_OUTCOMES'),
    border: true,
    frame: false,
    refreshStoreData:true,
    viewConfig: {
    	stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    	xtype : 'custompagingtoolbar',
    	plugins:['pagesize'],
    	store : 'program.MapCourseAndProgramOutcomeStore',
    	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    	displayInfo : true
    	} ]
    }],
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		displayInfo : true
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		displayInfo : true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		displayInfo : true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		displayInfo : true
	}/*{
			xtype: 'splitbutton',
			itemId: 'exportToPdfBtn',
			cls: 'CustomToolbarBtnExport',
			//iconCls:'export-pdf-icon',
			//text: 'Export To Pdf',      
			items: [{
				text: 'Export Current Page',
				itemId: 'exportCurrentPagePdf'
			}, {
				text: 'Export All',
				itemId: 'exportPdfAll'
			}],*/
		],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
    	header:  getProgramandcourseTranslation('PROGRAM_NAME'),
    	dataIndex: 'programName',
    	flex:.1,
    	sortable:true
    },{
    	header:  getProgramandcourseTranslation('BATCH'),
    	dataIndex: 'batchName',
    	flex:.1,
    	sortable:true,
    },{
    	header:  getProgramandcourseTranslation('PERIOD_ASSOCIATED'),
    	dataIndex: 'periodCount',
    	flex:.1,
    	sortable:true,
    	renderer:function(value){
    		if(value>0){
    			return  '<a href="#">'+value+'</a>';
    		}else{
    			return value;
    		}
    	}
    },{
    	header:  getProgramandcourseTranslation('PROGRAM_OUTCOME_ASSOCIATED'),
    	dataIndex: 'programOutcomeCount',
    	flex:.1,
    	sortable:true,
    	renderer:function(value){
    		if(value>0){
    			return  '<a href="#">'+value+'</a>';
    		}else{
    			return value;
    		}
    	}
    },{
    	header:  getProgramandcourseTranslation('COURSE_ASSOCIATED'),
    	dataIndex: 'courseCount',
    	flex:.1,
    	sortable:true,
    	renderer:function(value){
    		if(value>0){
    			return  '<a href="#">'+value+'</a>';
    		}else{
    			return value;
    		}
    	}
    },{
    	header:  getProgramandcourseTranslation('COURSE_OUTCOME_ASSOCIATED'),
    	dataIndex: 'courseOutcomeCount',
    	flex:.1,
    	sortable:true,
    	renderer:function(value){
    		if(value>0){
    			return  '<a href="#">'+value+'</a>';
    		}else{
    			return value;
    		}
    	}
    }]
});
