Ext.define('Academia.view.program.ProgramMasterGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.programmastergrid',
    store : 'program.ProgramMasterStore',
    title : getCommonTranslation('PROGRAM_MASTER'),
    border: true,
    autoScroll: true,
   // id:'programGridId',
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
	xtype : 'toolbar',
	dock : 'bottom',
	items : [ {
		xtype: 'custompagingtoolbar',
        plugins:['pagesize'],
        emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	    store : 'program.ProgramMasterStore',
	    displayInfo : true,
	    isGridConfigurable: true, //**
	    enableColumnHide: false,
		cbViewCode: CONSTANTS.CB.PROGRAM_LIST_VIEWCODE
	} ]
    }
    ],
    tbar: [{
    	xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
		//text : getCommonTranslation('VIEW')
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
		//text : getCommonTranslation('DELETE')
	}],
    columns : [{
	    header : getCommonTranslation('PROGRAM_CODE'),
	    dataIndex : 'programCode',
	    flex : .2,
	    sortable : true
	}, {
	    header : getCommonTranslation('PROGRAM_NAME'),
	    dataIndex : 'programName',
	    flex : .2,
	    sortable : true
	}, {
	    header : getCommonTranslation('PROGRAM_STATUS'),
	    dataIndex : 'programStatus',
	    flex : .2,
	    sortable : true,
		renderer: function(v) { 
			if(v=="0"){
				return "Open";
			}else{
				return "Closed";	
			}
        }
	}, {
	    header : getCommonTranslation('PROGRAM_CLOSURE_DATE'),
	    dataIndex : 'programClosureDate',
	    flex : .2,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
	    header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academy',
		sortable : true ,
		renderer: function(v) { 
            return v.value;
        }
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'location',
		sortable : true,
		renderer: function(v) { 
            return v.value;
        }
	},{
		header : getCommonTranslation('PROGRAM_STRUCTURE'),
		dataIndex : 'programStructure',
		sortable : true
	 }	    
	]

});
