/**
 * @author Abhishek.Bais
 */
Ext.define('Academia.view.program.SpecializationChangeWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.specializationchangewin',
	autoScroll: true,
	title:getProgramandcourseTranslation('CHANGE_SPECIALIZATION'),
	frame: true,
	autoScroll:true,
	modal:true,
	layout : {
		type : 'vbox'
	},
	method: 'POST',
	items: [{
		xtype: 'form',
		bodyPadding: '5 5 5 5',
		margin: 0,
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id_1',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				name:'programName',
				itemId:'programNameId',
				fieldLabel: getCommonTranslation('PROGRAM_NAME'),
			},{
				xtype:'displayfield',
				name:'batchName',
				itemId:'batchNameId',
				fieldLabel: getCommonTranslation('BATCH'),
			},{
				xtype:'displayfield',
				name:'studentBatchName',
				itemId:'studentBatchId',
				hidden:true,
				fieldLabel: getCommonTranslation('BATCH'),
			}]
		},
		{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'displayfield',
				name: 'periodName',
				itemId:'periodNameId',
				fieldLabel: getExaminationTranslation('PERIOD')
			},{
				xtype: 'displayfield',
				name: 'studentCount',
				itemId:'studentCountItemId',
				fieldLabel: getExaminationTranslation('Number of Students')
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id_3',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 450,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'specialization',
				itemId:'specializationId',
				allowBlank: false,
				fieldLabel: getProgramandcourseTranslation('SELECT_SPECIALIZATION'),
				store: 'program.SpecializationStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id_4',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 450,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'checkboxfield',
				name: 'checkFieldConfirm',
				itemId:'checkFieldConfirmItemId',
				boxLabel: getExaminationTranslation('Do you want to retain the data?'),
				checked:true,
				inputValue: 'true',
                uncheckedValue: 'false',
			}]
		},{	
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'-03px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'specializationSaveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'specializationCancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
