/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.view.program.SpecializationDetails', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.specializationdetails',  
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	standardSubmit : false,
	cls:'horizontalScrollingFixed',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width: 256,
		margin: 0
		
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		    xtype: 'customcombobox',
		    name: 'academyLocation',
		    itemId: 'academyLocationId',
		    fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
		    store: Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
		    width: 226,
		    valueField: 'id',
		    displayField: 'value',
		    allowBlank: false,
		    typeAhead: false,
		    forceSelection: true,

		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name: 'programName',
			itemId: 'programName',
			//store:'servicerequest.programcoursesectiontransfer.FromPrograms',
			store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.ProgramBatchPeriodByStudentId'),
			displayField: 'codeValue',
			valueField: 'programId',
			allowBlank: false,
			typeAhead: false,
			disabled:true,
			forceSelection: true,
		},{
			xtype: 'customcombobox',
			name: 'batchName',
			itemId:'batchName',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.enquiry.AcademicBatchStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			itemId:'periodIdItemId',
			name: 'periodId',
			store: Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.FromPeriodStore'),
			valueField: 'id',
			displayField: 'printName',
			allowBlank:false,
			typeAhead:false,
			forceSelection:true	 ,
			disabled:true
		},
		]},{
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
		}]
	}
		
	]
});
