Ext.define('Academia.view.program.lessonplanning.LessonPlanningDetailsForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.lessonplanningdetailsform',
	itemId:'lessonPlanningDetailsFormItemId',
	autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent',
	frame: true,
	method: 'POST',
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	plugins:"formlabelrequired",
	items:[
		{
	        xtype: 'hidden',
	        name: 'lessonPlanId',
	        itemId: 'lessonPlanIdItemId'
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 256,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype: 'customcombobox',
	    			name: 'lessonPlanAcademicTerm',
	    			itemId:'lessonPlanAcademicTermItemId',
	    			fieldLabel:getCommonTranslation('ACADEMIC_TERM'),
	    			displayField:'value',
	    			valueField:'id',
	    			forceSelection:true,
	    			allowBlank: false,
	    			queryMode:'local',
					typeAhead : false,
					forceSelection : true,
					anyMatch : true,
	    			listeners  :{
	    				render : function(combo){
	    					var store=Ext.create('Academia.store.common.AcademicTermStore');
	    					combo.bindStore(store)
	    					store.load();
	    				}
	    			}
	    		}
	    	]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'lessonPlanCourse',
					itemId : 'lessonPlanCourseItemId',
					store : Ext.create('Academia.store.course.CoursesWithoutLPStore'),
					displayField : 'courseCodeName',
					valueField : 'courseId',
					queryParam:'name',
					disabled: true,
	    			minChars:3,
	    			width: 536,
	    			allowBlank: false,
	    			typeAhead:false,
	    			enableKeyEvents  : 'true',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{courseCodeName}'  +
							'</div>';
						}
					}
	    		},{
	    			xtype : 'multiselectcombofield',
	    			fieldLabel : getCommonTranslation('COURSE_VARIANT'),
	    			name : 'lessonPlanCourseVariantId',
					itemId : 'lessonPlanCourseVariantIdItemId',
					store:'course.coursevariants.CourseVariantStore',
					displayField : 'courseVariantCode',
					valueField : 'id',
					disabled: true,
	    			allowBlank: true,
	    			hidden:true,
	    		    forceSelection: true,
	    		    width: 256,
	    		    matchFieldWidth:false,
	    		    _isStoreLoadCalled: true,
	    		    listConfig: {listeners: {
	    				beforeshow: function(picker) {
	    					picker.minWidth = picker.up('combobox').getSize().width;
	    					picker.width = 'auto';
	    					setTimeout(function(){
	    						picker.el.dom.style.width='auto';
	    						picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
	    					},10);
	    				}
	    			},
	    			loadingText: getCommonTranslation('SEARCHING'),
	    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    			getInnerTpl: function() {
	    				return '<div class="search-item">' +
	    				'{code}' +
	    				'</div>';
	    			}}
	    		}]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype: 'multiselectcombofield',
					fieldLabel: getCommonTranslation('FACULTY'),
					name:'lessonPlanFaculty',
					itemId:'lessonPlanFacultyItemId',
					store:'attendance.LessonPlanFacultyStore',
					displayField : 'value',
					valueField : 'id',
					allowBlank: true,
					disabled: true,
	    			forceSelection:true,
	    			minChars:3,
	    			queryParam:'name',
	    			editable:true,
	    			typeAhead:true,
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			triggerAction: 'all',
	    			hideTrigger:false,
	    			enableKeyEvents  : 'true',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			width: 256,
	    		    matchFieldWidth:false,
	    		    _isStoreLoadCalled: true,
					listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				}
	    			}
	    		},
	    		{
	            	xtype: 'textfield',
	                name: 'lessonPlanUnitTitle',
	                fieldLabel: getCommonTranslation('UNIT_TITLES'),
	                itemId:'lessonPlanUnitTitleItemId',
	                width :536,
	                disabled: true,
	                maxLength: 255,
	                allowBlank: false
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 256,
	    		labelAlign:'top'
	    	},
	    	items: [	    		
	    		{
	            	xtype: 'textfield',
	                name: 'lessonPlanTopics',
	                fieldLabel:getCommonTranslation('TOPICS'), //Teaching Hours for Sommet
	                itemId:'lessonPlanTopicsItemId',	
	                disabled: true,
	                maxLength: 255,
	                allowBlank: false,
	                listeners: {
	                	change: function(fld){
	                		var form = fld.up('form');
	                		var teachinHoursFld = fld;
	                		var studentLearningHoursFld = form.down('#lessonPlanTermItemId');
	                		var totalHoursFld = form.down('#totalHoursItemId');
	                		
	                		var teachinHours = !isNullOrEmpty(teachinHoursFld.getValue()) ? teachinHoursFld.getValue() : 0;
	                		var studentLearningHours = !isNullOrEmpty(studentLearningHoursFld.getValue()) ? studentLearningHoursFld.getValue() : 0;
	                		
	                		teachinHours = isNaN(teachinHours) ? 0 : teachinHours;
	                		studentLearningHours = isNaN(studentLearningHours) ? 0 : studentLearningHours;
	                		
	                		var totalHours = parseFloat(teachinHours)+parseFloat(studentLearningHours);
	                		
	                		totalHoursFld.setValue(totalHours);
	                	}
	                }
	            },
	            {
	            	xtype: 'numberfield',
	                name: 'superVisedPracticeHours',
	                fieldLabel:getCommonTranslation('SUPERVISED_PRACTICE_HOURS'), //Supervised Practice Hours for Sommet
	                itemId:'superVisedPracticeHours',	
	                disabled: true,
	                minValue:0,
	                maxValue:999999999,
	                allowBlank: true,
	                allowExponential:false
	            },
	            {
	            	xtype: 'textfield',
	                name: 'lessonPlanTerm',
	                fieldLabel: getCommonTranslation('TERM'), //Student Learning Hours for Sommet
	                itemId:'lessonPlanTermItemId',
	                disabled: true,
	                maxLength: 49,
	                allowBlank: false,
	                listeners: {
	                	change: function(fld){
	                		var form = fld.up('form');
	                		var studentLearningHoursFld = fld;
	                		var teachinHoursFld = form.down('#lessonPlanTopicsItemId');
	                		var totalHoursFld = form.down('#totalHoursItemId');
	                		
	                		var teachinHours = !isNullOrEmpty(teachinHoursFld.getValue()) ? teachinHoursFld.getValue() : 0;
	                		var studentLearningHours = !isNullOrEmpty(studentLearningHoursFld.getValue()) ? studentLearningHoursFld.getValue() : 0;
	                		
	                		teachinHours = isNaN(teachinHours) ? 0 : teachinHours;
	                		studentLearningHours = isNaN(studentLearningHours) ? 0 : studentLearningHours;
	                		
	                		var totalHours = parseFloat(teachinHours)+parseFloat(studentLearningHours);
	                		
	                		totalHoursFld.setValue(totalHours);
	                	}
	                }
	            },
	            {
	            	xtype: 'numberfield',
	                name: 'totalHours',
	                fieldLabel: getCommonTranslation('TOTAL_HOURS'), //Total Hours for Sommet
	                itemId:'totalHoursItemId',
	                readOnly: true,
	                allowBlank: true,
	                allowDecimals: true,
	                decimalPrecision: 2
	            }
	        ]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 256,
	    		labelAlign:'top'
	    	},
	    	items: [
	            {
	            	xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('DURATION'), //Level Of Study for Sommet
					name:'lessonPlanDuration',
					itemId: 'lessonPlanDurationItemId',
					store:'lessonplan.LessonPlanDurationStore',
					displayField: 'value',
					disabled: true,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: false
	            },
	            {
	            	xtype: 'customcombobox',
					fieldLabel: getProgramandcourseTranslation('GENERAL_EDUCATION_CATEGORY'),
					name:'generalEducationCategory',
					itemId: 'generalEducationCategoryItemId',
					store:'lessonplan.GeneralEducationCategoryStore',
					displayField: 'value',
					disabled: true,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: true
	            },
	            {
	            	xtype: 'customcombobox',
					fieldLabel: getProgramandcourseTranslation('REFERENCE_PROGRAM'),
					name:'referenceProgram',
					itemId: 'referenceProgramItemId',
					store:'lessonplan.ReferenceProgramStore',
					displayField: 'itemValue',
					disabled: true,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: true
	            }
	        ]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 256,
	    		labelAlign:'top'
	    	},
	    	items: [
	            {
	            	xtype: 'textfield',
					fieldLabel: getProgramandcourseTranslation('MAX_ABSENCES'),
					name:'maxAbsences',
					itemId: 'maxAbsencesItemId',
					displayField: 'value',
					//hidden: true,
					disabled: true,
					maxLength: 255,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: true
	            },
	            {
	            	xtype: 'textfield',
					fieldLabel: getProgramandcourseTranslation('ADMIN_ABSENCES'),
					name:'adminAbsences',
					itemId: 'adminAbsencesItemId',
					displayField: 'value',
					//hidden: true,
					disabled: true,
					maxLength: 255,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: true
	            },
	            {
	            	xtype: 'textfield',
					fieldLabel: getProgramandcourseTranslation('FACULTY_OFFICE_HOURS'),
					name:'facultyOfficeHours',
					itemId: 'facultyOfficeHoursItemId',
					displayField: 'itemValue',
					//hidden: true,
					disabled: true,
					maxLength: 255,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: true
	            }
	        ]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	                xtype: 'textareafield',
	                name: 'lessonPlanAim',
	                width:700,
	                fieldLabel:getCommonTranslation('AIMS'),
	                itemId:'lessonPlanAimItemId',	 
	                disabled: true,
	                allowBlank: false,
	                maxLength: 10000,
	                allowOnlyWhitespace: false
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		labelAlign:'top'
	    	},
	    	items: [{
	            	xtype: 'textareafield',
	                name: 'lessonPlanPrerequisite',
	                width:700,
	                fieldLabel:getCommonTranslation('PRE_REQUISITE'),
	                itemId:'lessonPlanPrerequisiteItemId',	                
	                allowBlank: true,
	                disabled: true,
	                hidden:true,
	                maxLength: 10000
	            }]
	    },
	    {
	    	xtype:'panel',
	    	itemId:'lessonPlanMainPnlItemId',
	    	width:700,
	    	style:{   			   
	    		left:'0px !important',
	    		marginLeft:'0px',
	    	},
	    	items:[]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	            	xtype: 'datefield',
	                anchor: '100%',
	                fieldLabel: getCommonTranslation('DATE_OF_PLANING'),
	                name: 'lessonPlanDateOfPlanning',
	                itemId:'lessonPlanDateOfPlanningItemId',
	              //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
	                allowBlank: true,
	    			vtype : 'daterange',
	    			listeners: {
	    				render: function(obj) {
	    					obj = dateFormatRender(obj);						
	    					obj.setValue(new Date());
	    				}
	    			}
	            }]
	    },{
		xtype: 'fieldcontainer',
		width: 256,
		defaults : {
			labelAlign : 'left'
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'checkbox',
			labelWidth: 256,
			itemId:'isValidationRequiredId',
			name: 'isValidationRequired',
			inputValue: true,
			hidden:true,
			uncheckedValue:false,
			checked:true,
			boxLabel: getCommonTranslation('IS_VALIDATION_REQUIRED'),
			//disabled:true
		}]
	},{
		xtype: 'fieldcontainer',
		defaults : {
			labelAlign : 'left'
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'checkbox',
			width: 800,
			itemId:'isRestrictMultipleLPOfaCourseId',
			name: 'isRestrictMultipleLPOfaCourse',
			inputValue: true,
			hidden:true,
			uncheckedValue:false,
			checked:true,
			boxLabel: getCommonTranslation('RESTRICT_MULTIPLE_LESSON_PLAN_OF_A_COURSE'),
			//disabled:true
		}]
	},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			cls:'horizontal-scrolling-fix',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype:'lessonplanningdocumentgrid',
				itemId:'lessonplanningdocumentgrid',
				style:{
					marginLeft:'0px'
				},
				hidden:true,
				isFixHeightGrid: true,
				cls: 'no-empty-placeholder-grid',
				minHeight: 0
			}]
		
		},
	    {
	    	xtype:'fieldcontainer',
	    	width:'100%',
			cls: 'form-fixed-footer',
			layout : {
				type : 'hbox'
			},
	    	//width:500,
	    	items: [{
	    		xtype: 'button',
	    		text: getCommonTranslation('SAVE'),
	    		itemId: 'lessonPlanSaveBtnItemId',
	    		ui: 'CustomBtnSubmit',
	    		scale: CONSTANTS.BUTTONSIZE,
	    		formBind: true
	    	}, {
	    		xtype: 'button',
	    		text: getCommonTranslation('Add Objective'),
	    		itemId: 'lessonPlanAddObjBtnItemId',
	    		ui: 'CustomBtnSubmit',
	    		disabled:true,
	    		scale: CONSTANTS.BUTTONSIZE
	    	},{
	    		xtype: 'button',
	    		text: getCommonTranslation('CANCEL'),
	    		itemId: 'lessonPlanCancelBtnItemId',
	    		ui: 'CustomBtnCancel',
	    		scale: CONSTANTS.BUTTONSIZE
	    	},
	    	{
				 xtype: 'button',
				 //width: 536,
				 text:getCommonTranslation('UPLOAD_DOC'),
				 itemId: 'lessonPlanUploadDocsBtnItemId',
				 ui: 'CustomBtnThird',
			   	 scale : CONSTANTS.BUTTONSIZE,
			   	 cls: 'no-icon-btn'
			
			},
			{
				 xtype: 'button',
				 //width: 536,
				 text:getCommonTranslation('ADD_EXAM_DETAIL'),
				 itemId: 'lessonPlanAddExamDetailBtnItemId',
				 ui: 'CustomBtnThird',
			   	 scale : CONSTANTS.BUTTONSIZE,
			   	 cls: 'no-icon-btn'
			
			},
			{
				 xtype: 'button',
				 text:getCommonTranslation('RESIT_DETAIL'),
				 itemId: 'lessonPlanResitDetailBtnItemId',
				 ui: 'CustomBtnThird',
			   	 scale : CONSTANTS.BUTTONSIZE,
			   	 cls: 'no-icon-btn'
			
			}]
	    }
	    ]

});
