/**
 * @author Phool Singh Gour
 * 
 */
Ext.define('Academia.view.program.lessonplanning.LessonPlanningFilter', {
	//extend: 'Ext.form.Panel',
	extend : 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.lessonplanningfilter',
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items :[ {  
				xtype: 'multiselectcombofield',
				width: 256,
				name: 'multiselectAcademyLocation',
				itemId: 'multiselectAcademyLocationId',
				allowBlank : false,
				editable:false,
				fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
				store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
				displayField:'value',
				valueField:'id',
				maxLength:15000,
				autoloadStore: false,
				queryMode:'local',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
							Ext.defer(function() {
								picker.getEl().dom.style.wordBreak='break-all';
							},200);
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			     },{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				allowBlank:false,
				queryMode:'local',
				typeAhead : false,
				forceSelection : true,
				anyMatch : true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.AcademicTermStore');
						combo.bindStore(store)
						store.load();
					}
				}
			},
			{
				xtype: 'customcombobox',
				name: 'courseCategory',
				itemId:'courseCategory',
				fieldLabel: getProgramandcourseTranslation('COURSE_CATEGORY'),
				store:'course.CourseCategoryStore',
				displayField:'value',
				valueField:'id',
				disabled: true,
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey: 'COURSE',
				name : 'courseItemId',
				itemId : 'courseItemId',
				store :Ext.create('Academia.store.course.AssignedPeriodCoursesFacultyStore'),
				//store : 'course.AssignedPeriodCoursesFacultyStore',
				displayField : 'courseCodeName',
				valueField : 'courseId',
				typeAhead : true,
				forceSelection : true,
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				disabled: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items :[
				{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
//				translationKey: 'COURSE_VARIANT',
				name : 'courseVariantId',
				itemId : 'courseVariantId',
				//store:'course.coursevariants.CourseVariantStore',
				store:Ext.create('Academia.store.lessonplan.CourseVariantOfLessonPlan'),
				displayField : 'code',
				valueField : 'id',
				disabled: true,
				//typeAhead : true,
				forceSelection : true
				//disabled:true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'program_Id',
				itemId : 'program_Id',
				store : Ext.create('Academia.store.common.AssignedProgramStore'),
				displayField : 'code',
				valueField : 'id',
				typeAhead : false,
				forceSelection : true,
				disabled : true,
				triggerAction: 'all',
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
				},{
					xtype: 'customcombobox',
					name: 'sectionGroupBatchId',
					itemId:'sectionGroupBatchId',
					fieldLabel : getCourseTxCommonTranslation('BATCH'),
					store: 'enquiry.AcademicBatchForSectionGroupStore',
					valueField: 'id',
					displayField: 'value',
					disabled: true,
					//typeAhead:true,
					queryMode:'local',
					typeAhead : false,
					forceSelection : true,
					anyMatch : true,
					width: 256,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items :[
				{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('PERIOD'),
					name : 'period_Id',
					itemId : 'period_Id',
					store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField : 'value',
					valueField : 'id',
					disabled: true,
					typeAhead : true,
					forceSelection : true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				}]
		},
		{
			xtype:'fieldset',
			title:getServiceRequestTranslation('MORE_FILTERS'),
			layout:'vbox',
			frame:true,	
			collapsible:true,
			collapsed:true,
			width:'100%',
			defaults: {
				labelAlign: 'top',
			},
			style: {
				marginTop: '40px!important',
			},
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('TERM'),
//					translationKey: 'PROGRAM',
					name:'termId',
					itemId: 'termId',
					store:Ext.create('Academia.store.lessonplan.LessonPlanTermStore'),
					displayField:'value',
					valueField: 'value',
					typeAhead:true,
					disabled: true,
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('UNIT_TITLES'),
					name:'unittitleId',
					itemId: 'unittitleId',
					store:Ext.create('Academia.store.lessonplan.LessonPlanUnitTitleStore'),
					displayField: 'value',
					valueField: 'value',
					typeAhead:true,
					disabled: true,
					forceSelection:true,
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				
				},{
					xtype: 'customcombobox',
					name:'facultyId',
					itemId:'facultyId',
					fieldLabel: getCommonTranslation('FACULTY'),
					store:Ext.create('Academia.store.attendance.AttendanceFacultyList'),
					displayField : 'facultyName',
					valueField : 'facultyId',
					queryParam:'name',
					//disabled: true,
					minChars:3,
					disabled: true,
					typeAhead:false,
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				    forceSelection : true,triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				}]
			},{

				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items :[{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('OBJECTIVES'),
//					translationKey: 'PROGRAM',
					name:'objectiveId',
					itemId: 'objectiveId',
					store:'lessonplan.LessonPlanObjectiveStore',
					displayField:'value',
					valueField: 'id',
					typeAhead:true,
					disabled: true,
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('DURATION'),
					name:'durationId',
					itemId: 'durationId',
					store:'lessonplan.LessonPlanDurationStore',
					displayField: 'value',
					valueField: 'id',
					typeAhead:true,
					disabled: true,
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
								Ext.defer(function() {
									picker.getEl().dom.style.wordBreak='break-all';
								},200);
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}'  +
							'</div>';
						}
					}
				
				}]
			
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'lessonPlanSearchBtn',
				buttonAlign: 'left',
				disabled: true,
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'lessonPlanResetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
