/**
 * @Author Phool Singh Gour
 */
Ext.define('Academia.view.program.lessonplanning.LessonPlanningGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.lessonplanninggrid',
	store : 'lessonplan.LessonPlanGridStore',
	title : getProgramandcourseTranslation('LESSON_PLANNING'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
    selType :'checkboxmodel',
    itemId: 'LessonPlanningGridId',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			  store : 'lessonplan.LessonPlanGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;
        if(portalId == 1){
        	this.headerFix = {
        			headerFix: true,
        			portalIdsWithStructure: {
        				'lessonplanningstructure': 1
        			}
        	};
        }
        else{
        	this.headerFix = {
        			headerFix: true,
        			portalIdsWithStructure: {
        				'personinfofacultyportal':2
        			}
        	};
        }
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     

 },	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon',
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	},{
		xtype: 'button',
		itemId: 'btnPublishId',
		disabled:true,
		text : getProgramandcourseTranslation('PUBLISH'),
		cls: 'CustomBtnSubmit',
		disabled: true,
		scale: CONSTANTS.BUTTONSIZE
	}, {
		xtype : 'button',
		itemId : 'lessonPlanningValidateBtn',
		tooltip : getCommonTranslation("VALIDATE"),
		text : getCommonTranslation("VALIDATE"),
		cls: 'CustomBtnSubmit',
		disabled: true
	}, {
		xtype: 'splitbutton',
		text: getCommonTranslation('MOREACTIONS'),
		itemId: 'btnMoreOperations',
		disabled:true,
		tooltip: getCommonTranslation('MOREACTIONS'),
		initComponent: function() {
			var btn=this;
			btn.menu= new Ext.menu.Menu({
				items: [{
					text: getCommonTranslation('PUBLISH'),
					itemId: 'moreActionPublishBtn',
					disabled:true
				},{
					text: getCommonTranslation("VALIDATE"),
					itemId: 'moreActionValidateBtn',
					disabled:true
				},{
					text: getCommonTranslation("UNPUBLISH"),
					itemId: 'moreActionUnPublishBtn',
					disabled:true
				},{
					text: getCommonTranslation("UNVALIDATE"),
					itemId: 'moreActionUnValidateBtn',
					disabled:true
				}, {
					itemId : 'lessonPlanningBulkCopyBtn',
					text : getProgramandcourseTranslation("BULK_COPY"),
					cls: 'CustomBtnSubmit',
					disabled: true
				}, {
					itemId : 'assessmentMapReportsId',
					tooltip : getCommonTranslation('ASSESSMENT_MAP_REPORT'),
					text : getCommonTranslation('ASSESSMENT_MAP_REPORT'),
					disabled: true,
					menu: {
						cls: 'print_export_btn_menu_cls',
						items: [{
							text: 'Excel',
							itemId: 'excelAssessmentMapReportBtn',
							cls: 'print_export_btn_menu_cls'
						},{
							text: 'Pdf',
							itemId: 'pdfAssessmentMapReportBtn',
							cls: 'print_export_btn_menu_cls'
						}]
					}
				}, {
					itemId : 'courseDescriptorReportsId',
					tooltip : getCommonTranslation('COURSE_DESCRIPTOR_REPORT'),
					text : getCommonTranslation('COURSE_DESCRIPTOR_REPORT'),
					disabled: true,
					menu:[/*{
						text: 'Word',
						itemId: 'excelCourseDescriptorReportBtn'
					},{
						text: 'Pdf',
						itemId: 'pdfCourseDescriptorReportBtn'
					}*/]
				}],
				listeners: { click: function() { this.showMenu(); } }
			});
	        this.callParent(arguments);  
		}
	
	}, {
		xtype : 'button',
		itemId : 'exportLessonPlanReportsId',
		tooltip : getCommonTranslation('EXPORT_REPORT'),
		text : getCommonTranslation('EXPORT_REPORT'),
		disabled: true,
		menu: {
			cls: 'print_export_btn_menu_cls',
			items: [{
				text: 'Excel',
				itemId: 'excelExportLessionPlansBtn',
				cls: 'print_export_btn_menu_cls'
			},{
				text: 'Pdf',
				itemId: 'pdfExportLessionPlansBtn',
				cls: 'print_export_btn_menu_cls'
			}]
		}
	}],
	columns : [
		{
			header: getProgramandcourseTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academyLocation',
			flex: .1,
			sortable:true
		},
		{
		header: getProgramandcourseTranslation('COURSE'),
		dataIndex: 'courseCodeName',
		flex: .1,
		sortable:true
	}, {
		header:  getProgramandcourseTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantCount',
		flex:.1,
		sortable:true,
		hidden: true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.courseVariantCount)) {
				if(record.data.courseVariantCount>1) {					
					return "<a href='#'>"+record.data.courseVariantCount+"</a>";
				} else if(record.data.courseVariantCount==1) {
					return "<a href='#'>"+record.data.courseVariantCount+"</a>";
				} 
			}                        
		}
	}, {
		header : getCommonTranslation('USER'),
		dataIndex : 'facultyArray',
		flex : .1,
		sortable : true,
		renderer:function(value,meta,record){
			if(record.data.facultyArray.length) {
				if(record.data.facultyArray.length == 1) {					
					return record.data.facultyArray[0];
				} else {
					return '<a href=#>'+record.data.facultyArray.length+'<a>';
				} 
			}
			else{
				return  "-";
			}
		}
	},{
		header : getCommonTranslation('UNIT'),
		dataIndex : 'unitTitle',
		flex : .1,
		sortable : true
	},{
		header : getCommonTranslation('TOPIC'),
		dataIndex: 'topics',
		flex:.1,
		sortable:true
	},{
		header : getCommonTranslation('TERM'),
		dataIndex : 'term',
		flex : .1,
		sortable : true
	},{
		header : getCommonTranslation('DURATION'),
		dataIndex : 'planDuration',
		flex : .1,
		sortable : true
	},{
		header : getCommonTranslation('OBJECTIVES'),
		dataIndex : 'objectiveCount',
		flex : .1,
		sortable : true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.objectiveCount)) {
				if(record.data.objectiveCount>1) {					
					return '<a href=#>'+record.data.objectiveCount+'<a>';
				} else if(record.data.objectiveCount==1) {
					return '<a href=#>'+record.data.objectiveCount+'<a>';
				} 
			}                        
		}
	},{
		header:  getCommonTranslation("DOCUMENTS"),
		dataIndex: 'documentCount',
		sortable:true,
		flex : .1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.documentCount)) {
				if(record.data.documentCount>1) {					
					return '<a href=#>'+record.data.documentCount+'<a>';
				} else if(record.data.documentCount==1){
					return '<a href=#>'+record.data.documentCount+'<a>';
				} 
			}                        
		}
	},{
		header:  getProgramandcourseTranslation("PUBLISH"),
		dataIndex: 'whethePublished',
		sortable:true,
		flex : .1,
		hidden: true
	},{
		header:  getCommonTranslation("VALIDATE"),
		dataIndex: 'whetherValidated',
		sortable:true,
		flex : .1,
		hidden: true
	}]
});
