/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.program.programDetails.curriculumAccreditation.curriculumAccreditationGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.curriculumaccreditationgrid',
    store: 'program.programDetails.curriculumAccreditation.curriculumAccGridStore',
    title: getCommonTranslation('CURRICULUM_ACCREDITATION'),
    border: true,
    autoScroll: false,
    frame: false,
    cls:'emtyMsgDesign',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSaveMapCurriculumItemId'
	}],
    columns: [{
        header: getCommonTranslation('CURRICULUM_ACCREDITATION'),
        dataIndex: 'curriculumAccreditationCode',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'curriculumAccreditation',
        	itemId: 'curriculumAccreditationItemId',
        	store:'program.programDetails.curriculumAccreditation.curriculumAccComboStore',
        	allowBlank: true,
        	displayField : 'value',
        	valueField : 'id',
        	triggerAction: 'all',
        	forceSelection: true,
        	enableKeyEvents : 'true',
        	listConfig: {
        		listeners: {
            		beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    },
        			select: function(obj, record){
        				var grid = Ext.ComponentQuery.query('curriculumaccreditationgrid')[0];
        				var selectedRecord = grid.getSelectionModel().getSelection()[0];
        				if(!isNullOrEmpty(selectedRecord.data.id)){
        					var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        				}else{
        					var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        				}
        				var flag = true;
        				if(flag){
        					if(!isNullOrEmpty(selectedRecord.data.id)){
        						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	

        					}else{
        						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
        					}
        				}else{
        					this.reset();
        					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('CURRICULUMA_CCREDITATION_ALREADY_SELECTED'));
        					return false;
        				}
        			}
        		}
        	} 
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
    		}
    	}
    },{
        header: getCommonTranslation('START_DATE'),
        dataIndex: 'startDateStr',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'startDateStr',
            itemId: 'startDateId',
            listeners: {
            	render: function(field) {
					return dateFormatRender(field);
				},
		        change: function(field, newValue) {
		            var grid = field.up('grid');
		            var selection = grid.getSelectionModel().getSelection();
		            if (selection.length > 0) {
		                var record = selection[0];
		                var endDateVal = record.get('endDateStr');
		                var endDate = null;

		                if (endDateVal) {
		                    if (Object.prototype.toString.call(endDateVal) === '[object Date]') {
		                        endDate = endDateVal;
		                    } else {
		                        endDate = new Date(endDateVal);
		                    }
		                }

		                if (endDate && newValue > endDate) {
		                	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('INVALID_DATE'));
		                    record.set('startDateStr', null);
		                    field.reset();
		                } else {
		                    record.set('startDateStr', Ext.Date.format(newValue, 'd/m/Y'));
		                }
		            }
		        }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        }
    },{
        header: getCommonTranslation('END_DATE'),
        dataIndex: 'endDateStr',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'endDateStr',
            itemId: 'endDateId',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                },
                change: function(field, newValue) {
                    var grid = field.up('grid');
                    var selection = grid.getSelectionModel().getSelection();
                    if (selection.length > 0) {
                        var record = selection[0];
                        var startDateVal = record.get('startDateStr');
                        var startDate = null;

                        if (startDateVal) {
                            if (Object.prototype.toString.call(startDateVal) === '[object Date]') {
                                startDate = startDateVal;
                            } else {
                                startDate = new Date(startDateVal);
                            }
                        }

                        if (startDate && newValue < startDate) {
                        	showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('INVALID_DATE'));
                            record.set('endDateStr', null);
                            field.reset();
                        } else {
                            record.set('endDateStr', Ext.Date.format(newValue, 'd/m/Y'));
                        }
                    }
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else if(!isNullOrEmpty(val)){
        		var date = moment(val, "DD/MM/YYYY").format("DD-MM-Y");
        		if(date == "Invalid date"){
        			date = moment(val, "MM/DD/YYYY").format("DD-MM-Y");
        		}
        		return date;
        	}
        	else{
        		rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
			}
        }
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	 if (record.data.isAddDeleteRow === true || !isNullOrEmpty(record.data.id)) {
             	return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
             }
            return '';
        }
    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            edit: function(editor, e, context) {
            	var rowData = e.record.data;
            	var grid = e.grid;
            }
        }
    }
});
