/**
 *  Prashant choudhary
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courses.NoOfAssociatedCourseGroup', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.noofassociatedcoursegroup',
	resizable:false,
	autoScroll: false,
	cls:'horizontalScrollingFixed',
	border:true,
	title:getProgramandcourseTranslation('COURSE_GROUP_ASSOCIATED'),
	store : 'course.coursegroup.CourseGroupByCourseIdStore',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.coursegroup.CourseGroupByCourseIdStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		
		var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments); 
	},
	
	tbar: [{
		xtype: 'button',
		itemId: 'btnSaveItemId',
		//disabled:true,
		text : getCommonTranslation('SAVE'),
		cls: 'CustomBtnSubmit',
		scale: CONSTANTS.BUTTONSIZE
    }],
	
	columns : [{
		header : getCommonTranslation('COURSE_GROUP_CODE'),
		dataIndex : 'code',
		flex : 1
	},{
		header : getCommonTranslation('COURSE_GROUP_NAME'),
		dataIndex : 'groupName',
		flex : 1
	},{
		header : getCommonTranslation('COURSE_GROUP_TYPE'),
		dataIndex : 'courseGroupType',
		flex : 1
	},{
		header : getCommonTranslation('COURSE_CLUSTER_ID'),
		dataIndex : 'courseClusterId',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('WHETHER_MAJOR'),
		dataIndex : 'whetherMajor',
		flex : 1,
		hidden:true,
		getEditor: function(record){
            return Ext.create('Ext.grid.CellEditor', {
                field: Ext.create( 'Academia.utilities.ux.CustomComboBox', {
                	name:'showWhetherMajor',
        			store:Ext.create('Academia.store.common.YesNoDynamicFormCombo'),
        			valueField : 'name',
        			displayField : 'value',
        			editable: false,
                })
            })
		}/*;
		editor : {
			xtype: 'customcombobox',
			name:'showWhetherMajor',
			store:Ext.create('Academia.store.common.YesNoDynamicFormCombo'),
			valueField : 'name',
			displayField : 'value',
			editable: false,
		},*/
	},{
			header: getCommonTranslation('ASSOCIATED_PARENT_COURSE_GROUP_NAME'),
			dataIndex: 'parentCourseGroupName',
			flex: 1,
			sortable: true
	}],
	
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
  }]

});