Ext.define('Academia.view.program.programDetails.programBatchDetails.courses.ProgramCoursesGrid', {
  //  extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias : 'widget.programcoursesgrid',
    store : 'program.programDetails.programBatches.programCourse.ProgramCourseStoreGrid',
    title : getCommonTranslation('COURSES_GRID'),
//    translationKey: 'COURSES_GRID',
    border: true,
    selType :'checkboxmodel',
    itemId: 'ProgramCoursesGridId',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    isGridConfigurable: true,
	enableColumnHide: false,
    dockedItems : [{
	    xtype: 'toolbar',
	    dock: 'bottom',
	    items: [{
	    	xtype: 'custompagingtoolbar',
	        plugins:['pagesize'],
	        store : 'program.programDetails.programBatches.programCourse.ProgramCourseStoreGrid',
	        emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	        displayInfo: true
	    }]
	}],
     initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
     },
    tbar: [{
    	xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
		//text : getCommonTranslation('EDIT')
	}/*,{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
		//text : getCommonTranslation('VIEW')
	}*/,{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
	    xtype : 'button',
	    itemId : 'mapPeriod',
	    tooltip : getCommonTranslation('MAP_PERIOD'),
	    text : getCommonTranslation('MAP_PERIOD')
	}],
    columns : [{
	    header :getCommonTranslation('PERIOD') ,
	    dataIndex : 'periodObj',
	    flex:.2,
	    sortable : false,
	    renderer : function(value, meta, record) {
			if (!isNullOrEmpty(record.data.periodDisplayObj)) {
				if (record.data.periodDisplayObj.length > 1) {
					return '<a href=#>'
							+ record.data.periodDisplayObj.length
							+ '<a>';
				} else if (record.data.periodDisplayObj.length == 1) {
					if(!isNullOrEmpty(record.data.periodDisplayObj[0].periodName)){
						return  '<a>'+record.data.periodDisplayObj[0].periodName + '<a>';
					}
				}
			}
		}
	},{
	    header :getCommonTranslation('COURSE_CODE') ,
	    dataIndex : 'courseCode',
	    flex:.2,
	    sortable : true
	}, {
	    header : getCommonTranslation('COURSE_NAME'),
	    dataIndex : 'courseName',
	    flex:.2,
	    sortable : true
	}, {
	    header : getCommonTranslation('COURSE_TYPE'),
	    dataIndex : 'whetherOptional',
	    flex:.2,
	    sortable : true,
	    renderer:function(v){
           if(v){
        	  return 'Optional';
           }else{
        	   return 'Mandatory'; 
           }    		
	    }
	},{
	    header : getCommonTranslation('COURSE_GROUP'),
	    dataIndex : 'courseGroupCount',
	    flex:.2,
	    sortable : true,
	    renderer:function(value){
			if(value!=null && value >0){
			  return '<a  href="#">'+value+'</a>';
			}else{
				return 0;
			}
		}
	},{
	    header : getCommonTranslation('COURSE_REPEATABLE'),
	    dataIndex : 'courseRepeatable',
	    flex:.2,
	    sortable : true,
	    hidden : true,
	    renderer:function(val){
	    	if(val){
	        	  return 'Yes';
	           }else{
	        	   return 'No'; 
	           }         		
	    }
	},{
		header : getCommonTranslation('IS_OFFERED_YEARLY'),
		dataIndex : 'isOfferedYearly',
		flex : .2,
		sortable : true,
		hidden : true,
		renderer:function(val){
			if(val==true){
				return 'Yes';
			}else{
				return 'No';
			}
		}
	}
	/*,{
	    header : getCommonTranslation('COURSE_PARAMETER_SETTING_STATUS'),
	    dataIndex : 'courseParameterStatus',
	    flex:.2,
	    sortable : true
	}	*/    
	]
});
 