/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.program.transfercredits.TCSearchStudent', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.tcsearchstudent',
	autoScroll: true,
	cls:'customSearchPanel',
	method : 'POST',
	/*layout : {
		type: 'anchor',
		layout: 'hbox'
	},*/
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width: 256
	},
	plugins : "formlabelrequired",
    isMinWidthNotRequired: true,
	items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		name:'batchId'
	},{
		xtype:'fieldcontainer',
		width: 'auto',
		layout : 'vbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name:'studentNameSearch',
				itemId:'studentNameSearch',
				//store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
				store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
				fieldLabel:getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width: 536,
				typeAhead:false,
				hideTrigger:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name:'evalautionPlanNo',
				itemId:'evalautionPlanNoItemId',
				store:'examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanTransferCredit',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'evaluationPlanNumber',
				minChars:3,
				typeAhead:false,
				allowBlank:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				disabled: true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'programWisePeriod',
				itemId:'programWisePeriodId',
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
				valueField: 'id',
				displayField: 'value',
				disabled:true,
				queryParam:'name',
				width: 536,
				typeAhead:true,
				allowBlank:true,
				minChars:3,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				_isStoreLoadCalled: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			},{
	            xtype: 'customcombobox',
	            name: 'enrollmentStatus',
	            itemId: 'enrollmentStatus',
	            store: Ext.create('Ext.data.Store', {
	            	fields: ['id', 'value'],
	            	data: [{
	            		id: '1',
	            		value: 'Enrolled'
	            	}, {
	            		id: '2',
	            		value: 'Pending'
	            	}, {
	            		id: '3',
	            		value: 'All'
	            	},{
	            		id: '4',
	            		value: 'Completed'
	            	}]
	            }),
	            displayField: 'value',
	            valueField: 'id',
	            forceSelection: true,
	            editable: false,
	            fieldLabel: getCommonTranslation('ENROLLMENT_STATUS'),
	            allowBlank: true
	        }]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'studentEnrolmntDetailTabSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'studentEnrolmntDetailTabResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
