/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.view.program.transfercredits.TransferCreditFilter', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.transfercreditfilter',  
	plugins : "formlabelrequired",
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items :[ {  
			xtype: 'multiselectcombofield',
			width: 256,
			name: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			allowBlank : false,
			editable:false,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			displayField:'value',
			valueField:'id',
			maxLength:15000,
			autoloadStore: false,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
						Ext.defer(function() {
							picker.getEl().dom.style.wordBreak='break-all';
						},200);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		     },
		     {

					xtype: 'customcombobox',
					name:'studentNameSearchTC',
					itemId:'studentNameSearchTCId',
					//store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameOrAdmissionCodeSmartSearch',
					store:'coursetransaction.studentenrollment.studentenrollmentdetail.SearchStudentByNameAndAcademyLocation',
					fieldLabel:getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
					valueField: 'secondId',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					width: 536,
					typeAhead:false,
					hideTrigger:true,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					allowBlank:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}'  +
							'</div>';
						}
					}
		     }]
	},
		{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
        	xtype: 'customcombobox',
            name: 'programGroup',
            itemId:'programGroupItemId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store:'program.ProgramGroupStore',
            displayField:'value',
            valueField:'id',
        	typeAhead:true,
			forceSelection:true,
            hideTrigger:false,	    
    	    triggerAction: 'all',
            minChars:3,
            queryParam:'programGrpName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        }, {
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:'program.ProgramCategoryStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
			queryMode: 'local',
			typeAhead: false,
			forceSelection: true,
		//	allowBlank: false,
			anyMatch: true
        },{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'common.ProgramForBillStore',
			displayField:'valueCode',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
            hideTrigger:false,	    
    	    triggerAction: 'all',
            minChars:3,
            queryParam:'programName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		//	allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchId',
			fieldLabel: getProgramandcourseTranslation('BATCH'),
			store:'enquiry.AcademicBatchStore',
			valueField:'id',
			displayField:'value',
			queryMode: 'local',
			typeAhead: false,
			forceSelection: true,
		//	allowBlank: false,
			anyMatch: true,
			disabled : true
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodId',
			fieldLabel: getProgramandcourseTranslation('PERIOD'),
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			disabled : true
		}
		]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'spclSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'spclResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
});
