/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.program.uploaddownload.CourseParameterUploadForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.courseparameteruploadform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	defaults: {
		width: 256,
		labelAlign: 'top'
	},
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'courseparameterUploadOptionRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [
			{
				xtype: 'customcombobox',
				itemId: 'uploadTypeItemId',
				labelAlign: 'top',
				fieldLabel: getProgramandcourseTranslation('TEMPLATE_FOR'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				allowBlank: true,
				triggerAction: 'all',
				width: 200,
				store: 'importutility.ImportCourseParameterUplaodTemplateStore',
				listeners: {
					select: function (combo, record) {
						var selectedId = record[0].get('id');
						var selectedValue = record[0].get('value');

						var form = combo.up('form');

						// Set the display field text
						form.down('#moduleNameDisplay').setValue(selectedValue);

						// Set the hidden field ID
						form.down('#moduleNameHidden').setValue(selectedId);
					}
				}
			},
			{
				xtype: 'textfield',
//				name: 'importUtilityMasterId',
				itemId: 'moduleNameDisplay',
				labelAlign: 'top',
				fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
				displayField: 'value',
				typeAhead: true,
				forceSelection: true,
				allowBlank: false,
				readOnly: true,
				editable: false,
				width: 200,
			},
			{
				xtype: 'hiddenfield',
				name: 'importUtilityMasterId',
				itemId: 'moduleNameHidden'
			}
			]
	},                    {
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 536,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
			change: function(fileField, value) {
				value = value.replace('C:\\fakepath\\', '');
				var newValue = value.replace(/ +/g, " ").split(' ').join('_');
				fileField.setRawValue(newValue);
				if (!isNullOrEmpty(newValue)) {
					var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
					var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
					if (!baseController.isValidFileExtensionForLoader(extension)) {
						fileField.reset();
						showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
					}
				}
			}
		}
	},{     
		xtype:'fieldcontainer',
		width:'auto',
		layout: 'hbox',
		style:{
			'margin-left':'-32px !important'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});