/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.program.uploaddownload.ProgramTermDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programtermdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		width: '100%',
		defaults: {
			labelAlign: 'top'
		},
		items : [{
            xtype: 'multiselectcombofield',
            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
    //        editable: true,
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width:410,
            allowBlank:false,
            cls: 'multiselectAcademyLocation',
            minChars:3,
            typeAhead:true,
            forceSelection :true,
            hideTrigger:false,
			triggerAction: 'all',
            queryParam:'qry',
            autoloadStore: false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				height:100,
				defaults: {
					labelAlign: 'top'
				},
				items : [{
					xtype: 'multiselectcombofield',
					name: 'programId',
					itemId: 'programItemId',
					fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					store : 'common.ProgramAssociatedWithPeriodByAcadLocation',
					width:410,
					queryParam:'qry',
					typeAhead : true,
					allowBlank:false,
					forceSelection:true,
					hideTrigger:false,
					triggerAction: 'all',
					autoloadStore: false,
					minChars:3,
					cls:'ProgramCourseMultiselectField',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
		    			listeners: {
		    				beforeshow: function(picker) {
		    					picker.minWidth = picker.up('combobox').getSize().width;
		    				}
		    			},
		    			loadingText: getCommonTranslation('SEARCHING'),
		    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    			getInnerTpl: function() {
		    				return '<div class="search-item">' +
		    				'{code} / {value}'+ 
		    				'</div>';
		    			}
		    		}
				},{
					xtype: 'multiselectcombofield',
					name: 'batchId',
					itemId: 'batchItemId',
					fieldLabel: getPersonModuleTranslation('BATCH'),
					store:'common.BatchesAssociatedWithPeriodByAcadAndProgram',
					disabled:true,
					width: 256,
					displayField: 'value',
					valueField: 'id',
					queryParam:'qry',
					typeAhead : true,
					allowBlank:false,
					forceSelection:true,
					hideTrigger:false,
					triggerAction: 'all',
					autoloadStore: false,
					minChars:3,
					cls:'ProgramCourseMultiselectField',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]},{
					xtype : 'fieldcontainer',
					width: '100%',
					layout : 'hbox',
					cls: 'customSearchPanelBtnsFieldContainerCls',
					style:{
		    			'margin-left':'-64px !important'
		    		},
					items : [{
						xtype: 'button',
						text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
						itemId: 'downoladBtnId',
						formBind : true,
						ui: 'CustomBtnSubmit'
					},{
						xtype: 'button',
						text: getCourseTxCommonTranslation('RESET'),
						itemId: 'resetBtn',
						//buttonAlign: 'left',
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]
				//}]
		}]
	}]
});
