/**
 * Abhishek Bais
 * 
 */
Ext.define('Academia.view.programCourseDashboard.CourseSearchAttendanceOfSectionGroup', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursesearchattendanceofsectiongroup',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: '536',
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION_GROUP'),
			name : 'sectionGroupId',
			itemId : 'sectionGroupId',
			store : Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			width: 256,
			allowBlank:false,
			
		},{
        	xtype: 'customcombobox',
			name: 'sectionGroupStudentId',
			itemId: 'sectionGroupStudentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			valueField: 'id',
			width: 256,
			displayField: 'valueCode',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//typeAhead:true,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'multiselectcombofield',
			width: 536,
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			name : 'courseId',
			itemId : 'course_Id',
			store:Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedCourseStore'),
			displayField : 'valueCode',
			valueField : 'id',
			typeAhead : true,
			disabled:true,
			forceSelection : true,
			allowBlank:true,
			queryParam:'name',
		},{
        	xtype: 'customcombobox',
    		name: 'studentStatusItemId',
    		itemId:'studentStatusItemId',
    		value:'Active',
    		store: 'student.studentprofile.ManuallyStudentStatusStore',
    		fieldLabel: getCommonTranslation('STUDENT_STATUS'),
    		valueField: 'value',
    		displayField: 'value',
    		editable: false,
    	    cls:'commonAutoHeightMultiselectField',
    	}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			displayField:'valueCode',
			valueField:'id',
			width: 256,
			typeAhead:false,
			disabled:true,
			forceSelection:true,
			queryParam:'programName',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			valueField: 'id',
			displayField: 'value',
			//typeAhead:true,
			forceSelection:true,
			width: 256
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'programBatch_periodId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store: Ext.create('Academia.store.programCourseDashboard.SectionGroupParameterizedProgramBatchStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			width: 256
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout:'hbox',
		itemId:'dateContainer',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'startDate',
			itemId:'startDate',
			endDateField : 'endDate',
//			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'endDate',
			itemId : 'endDate',
			startDateField : 'startDate',
//			format : CONSTANTS.DATE_FORMAT,
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}

		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});