Ext.define('Academia.view.programCourseDashboard.FacultyUtilizationGrid', {
	//extend : 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.facultyutilizationgrid',
	store : 'programCourseDashboard.FacultyUtilizationGridStore',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'programCourseDashboard.FacultyUtilizationGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text:getCommonTranslation('EXPORTREPORTS'),
		itemId:'exportReportsId',
		tooltip :getCommonTranslation('EXPORTREPORTS')
	}],
	columns : [	{
		header : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex:1
	},{
		header :getProgramandcourseTranslation('FACULTY_NAME'),
		dataIndex : 'facultyName',
		flex:1
	},{
		header : getProgramandcourseTranslation('NO_OF_COURSES'),
		dataIndex : 'noOfCourses',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getProgramandcourseTranslation('NO_OF_SESSIONS'),
		dataIndex : 'noOfSessions',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}/*,{
		header : getProgramandcourseTranslation('SCHEDULED_HOURS'),
		dataIndex : 'noOfHours',
		flex:1
	}*/,{
		header : getProgramandcourseTranslation('SCHEDULED_HOURS')+'('+getProgramandcourseTranslation('TIME_HHMM')+')',
		dataIndex : 'hours',
		flex:1
	},{
		header : getProgramandcourseTranslation('UTILIZATION'),
		dataIndex : 'utilizationPercentage',
		flex:1
	}]
});