/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.programCourseDashboard.NewSessionReportFilter', {   
	extend : 'Ext.panel.Panel',
	alias : 'widget.newsessionreportfilter',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	items: [{
			xtype:'form',
			plugins:"formlabelrequired",
			cls:'customSearchPanel',
			itemId:'newsessionreportfilter',
			items:[{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width: 256
					},
					items: [{
							xtype : 'customcombobox',
							fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
							name : 'academicTerm_New',
							itemId : 'academicTerm_New',
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							store: 'common.AcademicTermByPeriodIdsStore'
						},{
							xtype : 'customcombobox',
							fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
							name : 'programId_New',
							itemId : 'programId_New',
							store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
							displayField:'valueCode',
							valueField:'id',
							width: 256,
							typeAhead:true,
							forceSelection:true,
							queryParam:'name',
							minChars:3,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}'  +
									'</div>';
								}
							}
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('BATCH'),		
							name : 'batchId_New',
							itemId : 'batchId_New',
							store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true
						}]
				},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width: 256
					},
					items: [{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('PERIOD'),
							name : 'periodId_New',
							itemId : 'periodId_New',
							store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true
						},{
							xtype: 'customcombobox',
							name: 'courseCBSId_New',
							itemId: 'courseCBSId_New',
							store:'course.AssignedPeriodCoursesFacultyStore',
							fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
							valueField: 'courseId',
							displayField: 'courseCodeName',
							queryParam:'name',
							minChars:3,
							typeAhead:true,
							triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
							enableKeyEvents  : 'true',
							hideTrigger:false,
							forceSelection:true,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							width: 256,
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}'  +
									'</div>';
								}
							}
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('SECTION'),
							name : 'programSectionId_New',
							itemId : 'programSectionId_New',
							store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
							displayField : 'value',
							valueField : 'id',
							typeAhead : true,
							forceSelection : true,
							disabled:true
						},{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('SECTION'),
							name : 'courseSectionId_New',
							itemId : 'courseSectionId_New',
							store : 'attendance.AssignedSectionByCourseNComponent',
							displayField : 'sectionCode',
							valueField : 'sectionId',
							typeAhead : true,
							forceSelection : true,
							disabled:true,
							hidden:true
						}]
				},{
					xtype:'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults :{
						labelAlign:'top',
						width: 256
					},
					items: [{
							xtype: 'customcombobox',
							fieldLabel: getCourseTxCommonTranslation('FACULTY'),
							name: 'facultyId_New',
							itemId:'facultyId_New',
							store:'common.MappedFacultyStore',
							valueField: 'id',
							displayField: 'valueCode',
							queryParam:'name',
							minChars:3,
							typeAhead:false,
							hideTrigger:false,
							triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
							triggerAction: '',
							forceSelection:true,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code} / {value}' +
									'</div>';
								}
							}
						},{
							xtype: 'datefield',
							name:'fromDate_New',
							itemId:'fromDate_New',
							fieldLabel:getServiceRequestTranslation('FROM_DATE'),
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							},
							vtype: 'daterange',
							endDateField: 'toDate_New',
							editable:false
						},{
							xtype: 'datefield',
							name:'toDate_New',
							itemId:'toDate_New',
							fieldLabel:getServiceRequestTranslation('TO_DATE'),
							vtype: 'daterange',
							startDateField: 'fromDate_New',
							editable:false,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
						}]
				},{
					xtype: 'fieldcontainer',
					width: '100%',
		    		layout : {
		    			type : 'hbox'
		    		},
		    		cls: 'customSearchPanelBtnsFieldContainerCls',
					items: [{
							xtype: 'button',
							text: getCommonTranslation('SEARCH'),
							itemId: 'btnSearch_New',
							buttonAlign: 'left',
							ui: 'CustomBtnSubmit',
							scale: CONSTANTS.BUTTONSIZE               
						},{
							xtype: 'button',
							text: getCommonTranslation('RESET'),
							itemId: 'btnReset_New',
							ui: 'CustomBtnCancel',
							scale: CONSTANTS.BUTTONSIZE   
						}]	
				}]
		}]
});