/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.PendingSessionReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.pendingsessionreportgrid',
	store: 'programCourseDashboard.PendingSessionReportGridStore',
	title: getProgramandcourseTranslation('PENDING_SESSION_REPORT'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId : 'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'programCourseDashboard.PendingSessionReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'program',
		flex:.7
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batch',
		flex:.8
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'period',
		hidden: true,
		flex:.8
	},{
		header:  getProgramandcourseTranslation('SECTION'),
		dataIndex: 'section',
		flex:.8
	},{
		header:  getProgramandcourseTranslation('COURSE'),
		dataIndex: 'course',
		flex:1
	},{
		header:  getProgramandcourseTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:1
	},{
		header:  getProgramandcourseTranslation('FACULTY'),
		dataIndex: 'facultyName',
		flex:1
	},{
		header:  getProgramandcourseTranslation('DATE'),
		dataIndex: 'sessionDate',
		flex:.7,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getProgramandcourseTranslation('SESSION_NO'),
		dataIndex: 'sessionNumber',
		flex:.6
	},{
		header:  getProgramandcourseTranslation('TIME_FROM'),
		dataIndex: 'fromSlot',
		flex:.6,
        renderer:function(value, record){
        	return timeRender(value);
        }
	},{
		header:  getProgramandcourseTranslation('TIME_TO'),
		dataIndex: 'toSlot',
		flex:.6,
        renderer:function(value, record){
        	return timeRender(value);
        }
	}]
});
