/**
 * @author Rajkumar.patidar
 */
var ProgramPromotionStore = Ext.create('Academia.store.programCourseDashboard.ProgramPromotionStore');

Ext.define('Academia.view.programCourseDashboard.ProgramPromotionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programpromotiongrid',
	store : ProgramPromotionStore,
	title: getProgramandcourseTranslation('PROMOTION_LIST'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : ProgramPromotionStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	columns : [{
		header : getCommonTranslation('ADMISSION_NO'),
		dataIndex : 'admissionNo',
		flex:1,
		hidden:true
	},{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('From_Program'),
		dataIndex : 'fromProgramName',
		flex:1
	},{
		header : getCommonTranslation('FROM_BATCH'),
		dataIndex : 'fromBatchName',
		flex:1
	},{
		header : getCommonTranslation('FROM_PERIOD'),
		dataIndex : 'fromPeriodName',
		flex:1
	},{
		header : getCommonTranslation('From_Section'),
		dataIndex : 'fromSectionName',
		flex:1
	},{
		header : getCommonTranslation('To_Program'),
		dataIndex : 'toProgramName',
		flex:1
	},{
		header : getCommonTranslation('TO_BATCH'),
		dataIndex : 'toBatchName',
		flex:1
	},{
		header : getCommonTranslation('PERIOD_TO'),
		dataIndex : 'toPeriodName',
		flex:1
	},{
		header : getCommonTranslation('To_Section'),
		dataIndex : 'toSectionName',
		flex:1
	},{
		header : getCommonTranslation('USER_ID'),
		dataIndex : 'approverCode',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('ADMISSION_DATE_AD'),
		dataIndex : 'admissionDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('PROMOTION_DATE'),
		dataIndex : 'approvalDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('TOTAL_COMP_YEAR'),
		dataIndex : 'totalCompYear',
		flex:2
	}, {
		header : getCommonTranslation('ACTIVE_AT_CURRENT_ACADEMY_LOCATION'),
		dataIndex : 'activeAtCurrentLocation',
		flex:2
	},{
		header : getCommonTranslation('BRAND_CAMPUS'),
		dataIndex : 'brandCampus',
		flex:2
	},{
		header : getCommonTranslation('PROMOTION_BY'),
		dataIndex : 'approverName',
		flex:1
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'promotionStatus',
		flex:1,
		renderer : function(value){
			return getCommonTranslation(value);
		},
		hidden:true
	}]
});