/**
 * @author Abhishek Bais
 */
Ext.define('Academia.view.programCourseDashboard.StudentCourseEnrollmentReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentcourseenrollmentreportgrid',
	store: 'programCourseDashboard.StudentCourseEnrollmentReportStore',
	title: getProgramandcourseTranslation('STUDENT_COURSE_ENROLLMENT_REPORT'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'programCourseDashboard.StudentCourseEnrollmentReportStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	tbar: [{
	    xtype : 'button',
	    itemId : 'exportStudentCourseEnrollmentReportsId',
	    tooltip : getCommonTranslation('EXPORT_REPORT'),
	    text : getCommonTranslation('EXPORT_REPORT'),
	    disabled: true,
	}],
	columns: [{
		header:  getProgramandcourseTranslation('STUDENT_PERIOD_ENROLLMENT_STATUS'),
		dataIndex: 'studentPeriodEnrollmentStatus',
		flex:.1,
		sortable:true
	}, {
		header:  getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1
	}, {
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : .1,
		hidden :true
	},{
		header:  getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('SUBJECT_TYPE'),
		dataIndex: 'whetherOptional',
		flex:.1,
		sortable:true,
		renderer:function(v){
		    	if(v){
		    		return getCommonTranslation('OPTIONAL');
		    	}else{
		    		return getCommonTranslation('MANDATORY');
		    	}
		    }
	},{
		header:  getCommonTranslation('COURSE_CREDITS'),
		dataIndex: 'courseCredits',
		flex:.1,
		sortable:true
	}]
});
