/**
 * @author Amit Gupta
 */
Ext.define('Academia.view.quartz.quicksearch.QuartzQuickSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.quartzquicksearch',
    autoScroll: false,
    frame: false,
    border:false,
    plugins : "formlabelrequired",
    cls:'customSearchPanel',
    ///layout: 'vbox',
    
   /* items: [{
        xtype: 'form',
        width: '100%',*/
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
    				xtype: 'customcombobox',
    				name: 'jobName',
    				itemId:'jobName',
    				 fieldLabel: getCommonTranslation('JOB_NAME'),
    				store: 'quartz.QuartzNameSmartSearch',
    				valueField: 'value',
    				displayField: 'value',
    				width: 452,
    				queryParam:'jobName',
    				forceSelection:true,
    				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    				enableKeyEvents  : 'true',
    				minChars:3,
    				typeAhead:false,
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    				triggerAction: 'all',
    				hideTrigger:false,
    				listConfig: {
    					listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    					loadingText: getCommonTranslation('SEARCHING'),
    					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    					getInnerTpl: function() {
    						return '<div class="search-item">' +
    						'{value}' +
    						'</div>';
    					}
    				}
            },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('JOB_STATUS'),
                name: 'jobState',
                itemId:'jobState',
                editable: false,
                store: 'quartz.QuartzStateSearch',
                displayField: 'value',
                valueField: 'id'/*,
                allowBlank : false*/
            },{
				xtype: 'datefield',
				name:'dateFrom',
				itemId:'quartz_date_from',
				hidden: true,

				vtype: 'daterange',
				endDateField:'quartz_date_to',
				fieldLabel:getCommonTranslation('QUARTZ_DATE_FROM'),
				listeners: {
					render: function(field) {
						var obj = dateFormatRender(field);

						//obj.setValue(new Date());
					}
				}
				//--submitFormat: CONSTANTS.DATE_FORMAT
			},{
				xtype: 'datefield',
				name:'enquiryDateto',
				itemId:'quartz_date_to',
				hidden: true,

				vtype: 'daterange',
				startDateField:'quartz_date_from',

				fieldLabel:getCommonTranslation('QUARTZ_DATE_TO'),
				listeners: {

					render: function(field) {
						var obj = dateFormatRender(field);
						//obj.setValue(new Date());
					}
              }

            //--submitFormat: CONSTANTS.DATE_FORMAT
			}]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
	              xtype: 'button',
                  text: getCommonTranslation('SEARCH'),
                  formBind: true,
                  itemId: 'SearchBtn',
                  ui: 'CustomBtnSubmit',
                  scale: CONSTANTS.BUTTONSIZE
              },{
	        	  xtype: 'button',
	              text: getCommonTranslation('RESET'),
	              itemId: 'cancelBtn',
	              ui: 'CustomBtnCancel',
	              scale: CONSTANTS.BUTTONSIZE,
	              handler: function() {
	            	  var form = this.up('form');
	            	  form.getForm().reset();
	            	  form.down('#quartz_date_from').setValue(new Date());
	            	  form.down('#quartz_date_to').setValue(new Date());
	            	}
                }]
        }]

   // }]{

});