/**
 * @author Amit G
 */
Ext.define('Academia.view.receipt.receiptsettings.BillSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.billsettingswin',
    title: getFeeAndPaymentCommonTranslation('BILL_SETTINGS'),
  //  width:550,
   // height:300,
    modal: true,
    autoScroll: true,
    items: [{
        xtype: 'form',
        itemId: 'billSettingsFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id'
            }, {
                xtype: 'multiselectcombofield',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                autoloadStore: false,
                width: 536,
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                store: Ext.create('Academia.store.receipt.receiptsettings.AcademyLocationNotInBillSettings'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                queryParam: 'qry'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 230,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'backDateAllowInDays',
                itemId: 'backDateAllowInDaysItemId',
                fieldLabel: getCommonTranslation('RS_BACK_DATE_DAYS'),
                allowBlank: false,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            },{
                xtype: 'numberfield',
                name: 'futureDateAllowInDays',
                itemId: 'futureDateAllowInDaysItemId',
                fieldLabel: getCommonTranslation('RS_FUTURE_DATE_DAYS'),
                allowBlank: true,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            }]
        },{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'right',
				width:230,
			},
			items:[{
				xtype: 'checkboxfield',
				//width: 'auto',
				//labelAlign: 'left',
				boxLabel: getFeeAndPaymentCommonTranslation('SHOW_ADDITIONAL_COLUMNS'),
				name: 'showAdditionalColumns',
				itemId: 'showAdditionalColumns',
				//style: 'float:left;',
				inputValue: true
			
			},{
				xtype: 'checkboxfield',
				//width: 'auto',
				//labelAlign: 'left',
				//style:{marginLeft:'50px'},
				boxLabel: getFeeAndPaymentCommonTranslation('DUE_DATE_EDITABLE'),
				name: 'dueDateEditable',
				itemId: 'dueDateEditable',
				inputValue: false
			}]
		}, {
			xtype:'fieldcontainer',
			width:400,
			layout : 'hbox',
			defaults: {
				labelAlign:'right',
				width:'100%',
			},
			items:[{
				xtype: 'checkboxfield',
				labelAlign: 'left',
				boxLabel: getCommonTranslation('BILL_GENERATION_ON_SUBMIT_APPLICATION'),
				name: 'billGenerationOnSubmitApplication',
				itemId: 'billGenerationOnSubmitApplication',
			}]
		},{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveBillSettingsWinItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelBillSettingsWinItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});