/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.receipt.receiptsettings.ConfigureFeeHeadGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.configurefeeheadgrid',
	title: getCommonTranslation('FEE_HEAD_CONFIGURATION'),
	store: Ext.create('Academia.store.receipt.receiptsettings.PaymentTermConfigureGridStore'),
	border: true,
	itemId: 'paymentGroupConfigureFeeHeadGrid',
	autoScroll: false,
	 cls:'centerAlignTitle',
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{   
		xtype: 'button',
		text: getCommonTranslation('SUBMIT'),
		itemId: 'submitBtn',
		scale: CONSTANTS.BUTTONSIZE,
		cls:'submitBtnCls'
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE,
		hidden:true
	}],
	columns: [{
		header:  getFeeAndPaymentCommonTranslation('FEES_HEADS'),
		dataIndex: 'feeHeadName',
		flex:.1,
		sortable: false,
		/*editor:{
			xtype: 'customcombobox',
			itemId: 'subheadItemId',
			name: 'subHeadName', 
			store:Ext.create('Academia.store.feeandpayment.coursefeedefinition.FeeHeadConfigurationSubHeadStore'),
			valueField:'id',
			displayField:'value',
			typeAhead:false,
			forceSelection:true,
			queryParam:'qry',
			id: 'resume-applicantdetails-view-address',

		},
		listeners: {
			render: function(combo){
				if(!isNullOrEmpty(combo)){
					combo.getEditor().store.load();
				}
			}
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}*/
	},{
		header:  getCommonTranslation('WEIGHTAGE'),
		dataIndex: 'paymentTermWeightage',
		flex:.1,
		sortable: false,
		/*editor:{
			xtype: 'numberfield',
			itemId: 'amountOrWeightage',
			name: 'amountOrWeightage', 
			maxValue:100,
			minValue:1,
			allowDecimals:false,
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}*/
	},{
		header:  getFeeAndPaymentCommonTranslation('COST_CENTER'),
		dataIndex: 'costCentre',
		flex:.1,
		sortable: false,
		renderer: function(value, metadata, record) {
			if(record.get('costCentre')){
				return record.get('costCentre').value;
			}
		}
	 },{
		header:  getFeeAndPaymentCommonTranslation('DISCOUNT'),
		dataIndex: 'whetherPayableDiscount',
		flex:.1,
		sortable: false,
		renderer: function(value, metadata, record) {
			if(record.get('whetherPayableDiscount')){
				return "Yes";
			}else{
				return "No";
			}
		}
	 }/*,
	{
		header: getCommonTranslation('ADD'),
		dataIndex: 'addButton',
		flex:.1,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: false,
		renderer: function(value, meta, record) {
			var configurationTab = Ext.ComponentQuery.query('paymentgroupconfigurefeeheadsstructure')[0];
//			if(configurationTab.addPermission){
				if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId)){
					return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
				}
//			}else{
//				return '';
//			}
		}
	}, {
		header: getServiceRequestTranslation('EMM_DELETE'),
		dataIndex: 'deleteButton',
		flex:.1,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: false,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			var configurationTab = Ext.ComponentQuery.query('paymentgroupconfigurefeeheadsstructure')[0];
//			if(configurationTab.deletePermission){
				if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.manageCourseOutComeId)) {
					return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
				}
//			}else{
//				return '';
//			}
				
			
		}
	}*/],
	/*plugins: {
		ptype: 'cellediting',
		clicksToEdit: 1,
	},*/
});
