/**
 * @author Amit G
 */
Ext.define('Academia.view.receipt.receiptsettings.EditDiscountDateSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.editdiscountdatesettingswin',
    title: getFeeAndPaymentCommonTranslation('DISCOUNT_DATE_SETTINGS'),
    modal: true,
    autoScroll: true,
    items: [{
        xtype: 'form',
        itemId: 'editDiscountDateSettingsFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id',
                itemId: 'idItemId'
            }, {
                xtype: 'customcombobox',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                autoloadStore: false,
                width: 536,
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                store: 'common.AcademyLocationNameSeparated',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                readOnly: true
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'backDateAllowInDays',
                itemId: 'backDateAllowInDaysItemId',
                fieldLabel: getCommonTranslation('RS_BACK_DATE_DAYS'),
                allowBlank: false,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            style: {
                marginLeft: '-3px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveEditDiscountDateSettingsWinItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelEditDiscountDateSettingsWinItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});