/**
 *  @author manisha wagh
 */

Ext.define('Academia.view.receipt.receiptsettings.PaymentGrpMappingAcademyLocationGrid', {
	extend : 'Ext.grid.Panel',
//	alias : 'widget.academylocationgrid',
	alias : 'widget.paymentgrpmappingacademylocationgrid',
	title : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
	store: 'feeandpayment.AcademyLocationFeeMappingList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getFeeAndPaymentCommonTranslation('NEXT'),
		tooltip: getFeeAndPaymentCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('RESET'),
		tooltip: getFeeAndPaymentCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'academylocationsearchcombo',
		itemId:'academylocationsearchcombo',
		store: 'common.AcademyLocationByName',
		valueField: 'id',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width: 256,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'value',
		flex : 1	 
	}]
});