/**
 * @author Deepika P
 *  V2D-239844
 */
Ext.define('Academia.view.receipt.receiptsettings.ProgramGroupSettingPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.programgroupsettingpanel',
    autoScroll: true,
    layout: 'hbox', // Horizontal layout
    items: [{ 
    	xtype: 'tabpanel',
    	plain: true,
    	cls: 'horizontal-scrolling-fix',
    	frame: false,
    	border: false,
    	margin:'0 0 0 0',
    	flex: 1, // Ensure this takes more space than the grid
    	items: [
    		{
    			title: getCommonTranslation('PAYMENT_GROUP'),
    			closable: false,
    			xtype: 'panel',
    			border: false,
    			cls: 'removeBorderCls',
    			style:{
    				'border-right': '1px solid var(--border-color-disabled) !important;'
    			},
    			items:[
    				{
    					xtype: 'grid',
    					title: getCommonTranslation('PAYMENT_GROUP'),
    					border: false,
    					cls:'centerAlignTitle',
    					refreshStoreData: true,
    					margin: "0 0 0 0",
    					itemId: 'paymentGroupMasterParentGrid',
    					store: 'receipt.receiptsettings.ProgramGroupParentGridStore',
    					flex: 1, // Use flex to ensure proper width allocation
    					columns: [
    						{
    							header: getCommonTranslation('ITEM_CODE'),
    							dataIndex: 'code',
    							flex: 1
    						},
    						{
    							header: getCommonTranslation('ITEM_NAME'),
    							dataIndex: 'name',
    							flex: 1
    						},
    						{
    							header: getCommonTranslation('PROGRAM_BATCH_MAPPED'),
    							dataIndex: 'mappedProgramCount',
    							flex: 1,
    							renderer: function (val, rec, e) {
    								if (!isNullOrEmpty(val)) {
    									if (val == '0' || val == '0.00' || val == '0.0') {
    										return "-";
    									} else {
    										return "<a href='#'>" + val + "</a>";
    									}
    								} else {
    									return "-";
    								}
    							}
    						}
    						],
    						viewConfig: {
    							stripeRows: CONSTANTS.STRIPEROWS,
    							deferEmptyText: false
    						},
    						dockedItems: [
    							{
    								xtype: 'toolbar',
    								dock: 'bottom',
    								items: [
    									{
    										xtype: 'custompagingtoolbar',
    										plugins: ['pagesize'],
    										store: 'receipt.receiptsettings.ProgramGroupParentGridStore',
    										emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    										displayInfo: true
    									}
    									]
    							}
    							],
    							tbar: [
    								{
    									xtype: 'button',
    									itemId: 'btnAdd',
    									tooltip: getCommonTranslation('ADD'),
    									glyph: ICONGLYPH.ADDGLYPH
    								},
    								{
    									xtype: 'button',
    									itemId: 'btnEdit',
    									tooltip: getCommonTranslation('EDIT'),
    									glyph: ICONGLYPH.EDITGLYPH,
    									disabled: true
    								},
    								{
    									xtype: 'button',
    									itemId: 'btnView',
    									tooltip: getCommonTranslation('VIEW'),
    									iconCls: 'view-icon',
    									disabled: true
    								},
    								{
    									xtype: 'button',
    									itemId: 'btnDelete',
    									cls: 'CustomToolbarBtnReject',
    									tooltip: getCommonTranslation('DELETE'),
    									glyph: ICONGLYPH.DELETEGLYPH,
    									disabled: true
    								},
    								{
    									xtype: 'splitbutton',
    									itemId: 'spBtnMoreActions',
    									text: getFeeAndPaymentCommonTranslation('MOREACTIONS'),
    									menu: [
    										{
    											text: getFeeAndPaymentCommonTranslation('APPLICABLE_FOR'),
    											itemId: 'doMappingLink'
    										}
    										],
    										listeners: {
    											click: function () {
    												this.showMenu();
    											}
    										}
    								}
    								]
    				},
    				]
    		}]
    },
    {
    	xtype: 'tabpanel',
    	plain: true,
    	cls: 'horizontal-scrolling-fix',
    	frame: false,
    	border: false,
    	margin:'0 0 0 0',
    	flex: 1, // Ensure this takes more space than the grid
    	items: [
    		{
    			title: getCommonTranslation('PAYMENT_TERM'),
    			closable: false,
    			xtype: 'panel',
    			border: false,
    			cls: 'removeBorderCls',
    			items: [
    				{
    					xtype: 'grid',
    					border: false,
    					cls:'centerAlignTitle',
    					margin: "0 0 0 0",
    					title: getCommonTranslation('PAYMENT_TERM'),
    					itemId: 'paymentGroupChildGrid',
    					store: 'receipt.receiptsettings.ProgramGroupChildGridStore',
    					refreshStoreData: true,
    					viewConfig: {
    						stripeRows: CONSTANTS.STRIPEROWS
    					},
    					tbar: [
    						{
    							xtype: 'button',
    							itemId: 'btnAdd',
    							tooltip: getCommonTranslation('ADD'),
    							iconCls: 'icon-addbutton',
    							cls: 'addbutton',
    							disabled: true
    						},
    						{
    							xtype: 'button',
    							itemId: 'btnEdit',
    							tooltip: getCommonTranslation('EDIT'),
    							iconCls: 'icon-editbutton',
    							cls: 'editbutton',
    							disabled: true
    						},
    						{
    							xtype: 'button',
    							itemId: 'btnView',
    							tooltip: getCommonTranslation('VIEW'),
    							iconCls: 'icon-View',
    							cls: 'iconView',
    							disabled: true
    						},
    						{
    							xtype: 'button',
    							itemId: 'btnDelete',
    							cls: 'CustomToolbarBtnReject',
    							tooltip: getCommonTranslation('DELETE'),
    							iconCls: 'icon-Delete',
    							cls: 'iconDelete',
    							disabled: true
    						},
    						{
    							xtype: 'button',
    							itemId: 'btnConfigureFeeHead',
    							text: getCommonTranslation('CONFIGURE_FEE_HEAD'),
    							disabled: true
    						}
    						],
    						dockedItems: [
    							{
    								xtype: 'toolbar',
    								dock: 'bottom',
    								items: [
    									{
    										xtype: 'custompagingtoolbar',
    										plugins: ['pagesize'],
    										store: 'receipt.receiptsettings.ProgramGroupChildGridStore',
    										emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    										displayInfo: true
    									}
    									]
    							}
    							],
    							columns: [
    								{
    									header: getCommonTranslation('PAYMENT_TERM_CODE'),
    									dataIndex: 'code',
    									flex: 1
    								},
    								{
    									header: getCommonTranslation('PAYMENT_TERM_NAME'),
    									dataIndex: 'name',
    									flex: 1
    								},
    								{
    									header: getCommonTranslation('SEQUENCE_NO'),
    									dataIndex: 'sequenceNo',
    									flex: 1
    								},
    								{
    									header: getCommonTranslation('FEE_HEAD'),
    									dataIndex: 'configureFeeHeadCount',
    									flex: 1,
    									sortable: true,
    									renderer: function (value, meta, record) {
    										if (!isNullOrEmpty(value) && value > 0) {
    											return '<a href="#">view</a>';
    										}
    									}
    								},
    								{
    									header: getCommonTranslation('IS_DEFAULT'),
    									dataIndex: 'isDefaultPaymentTerm',
    									flex: 1,
    									renderer: function (value, meta, record) {
    										return value ? 'Yes' : 'No';
    									}
    								}
    								]
    				}
    				]
    		}
    		]
    }
    ]
});

