/**
 * @author Varsha Gour
 */
Ext.define('Academia.view.receipt.receiptsettings.ReceiptSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.receiptsettingswin',
    title: getCommonTranslation('RS_RECEIPT_SETTINGS'),
    modal: true,
    autoScroll: true,
    items: [{
        xtype: 'form',
        itemId: 'receiptSettingsFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id'
            }, {
                xtype: 'multiselectcombofield',
                name: 'academyLocationId',
                itemId: 'academyLocationItemId',
                autoloadStore: false,
                width: 536,
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
                store: Ext.create('Academia.store.receipt.receiptsettings.AcademyLocationNotInReceiptSettings'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                queryParam: 'qry',
                typeAhead: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
            	 width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'numberfield',
                name: 'numberOfDays',
                itemId: 'numberOfDaysItemId',
                fieldLabel: getCommonTranslation('RS_BACK_DATE_DAYS'),
                allowBlank: false,
                minValue: 1,
                maxValue: 1000,
                maxLength: 4,
                allowExponential: false,
                allowDecimals: false,
                hideTrigger: true,
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'right',
				width:230,
			},
            items: [{
    			xtype: 'checkboxfield',
    			labelAlign: 'right',
    			boxLabel: getFeeAndPaymentCommonTranslation('ALLOW_AMOUNT_VALUE_IN_DECIMAL'),
    			name: 'allowAmountValueInDecimal',
    			itemId: 'allowAmountValueInDecimal',
    			inputValue: true
    		}
            ,{
    			xtype: 'checkboxfield',
    			labelAlign: 'right',
    			boxLabel: getFeeAndPaymentCommonTranslation('AUTO_FETCH_RECEIPT_AMOUNT'),
    			name: 'autoFetchReceiptAmount',
    			itemId: 'autoFetchReceiptAmount',
    			checked:true,
    			inputValue: true
    		}]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'btnSaveReceiptSettingsWinItemId',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            },
            {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelReceiptSettingsWinItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});